/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class GenericSelectionScreen<T extends NarrativeEntry>
extends Screen {
    protected final List<T> itemList;
    protected final Consumer<T> consumer;
    protected final T currentSelection;
    protected final String screenTitle;
    protected final Screen lastScreen;
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private SelectionList<T> selectionList;

    public GenericSelectionScreen(Screen lastScreen, String screenTitle, List<T> itemList, T currentSelection, Consumer<T> consumer) {
        super((Component)Component.literal((String)screenTitle));
        this.lastScreen = lastScreen;
        this.screenTitle = screenTitle;
        this.itemList = itemList;
        this.currentSelection = currentSelection;
        this.consumer = consumer;
    }

    protected void init() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addTitle() {
        LinearLayout linearlayout = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.horizontal())).spacing(8);
        linearlayout.defaultCellSetting().alignVerticallyMiddle();
        linearlayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
        this.addCustomTitleButtons(linearlayout);
    }

    protected void addCustomTitleButtons(LinearLayout layout) {
    }

    protected void addContents() {
        this.selectionList = (SelectionList)this.layout.addToContents(new SelectionList(this.minecraft, this));
    }

    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_345997_ -> this.onClose()).width(200).build());
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.selectionList.updateSize(this.width, this.layout);
    }

    public void onClose() {
        SelectionList.Entry entry = (SelectionList.Entry)this.selectionList.getSelected();
        if (entry == null) {
            this.consumer.accept(null);
        } else {
            this.consumer.accept(entry.getItem());
            this.minecraft.setScreen(this.lastScreen);
        }
    }

    protected List<T> getItemList() {
        return this.itemList;
    }

    protected T getCurrentSelection() {
        return this.currentSelection;
    }

    static class SelectionList<T extends NarrativeEntry>
    extends ObjectSelectionList<Entry> {
        private final GenericSelectionScreen<T> parentScreen;

        public SelectionList(Minecraft minecraft, GenericSelectionScreen<T> parentScreen) {
            super(minecraft, parentScreen.width, parentScreen.height - 33 - 53, 33, 18);
            this.parentScreen = parentScreen;
            String selectedName = "";
            if (parentScreen.getCurrentSelection() != null) {
                selectedName = ((NarrativeEntry)parentScreen.getCurrentSelection()).getName();
            }
            for (NarrativeEntry item : parentScreen.getItemList()) {
                Entry entry = new Entry(this, item);
                this.addEntry((AbstractSelectionList.Entry)entry);
                String itemName = item.getName();
                if (!selectedName.equalsIgnoreCase(itemName)) continue;
                this.setSelected((AbstractSelectionList.Entry)entry);
            }
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public static class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final T item;
            final /* synthetic */ SelectionList this$0;

            public Entry(T item) {
                this.this$0 = this$0;
                this.item = item;
            }

            public T getItem() {
                return this.item;
            }

            public void render(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, int i6, boolean isSelected, float partialTick) {
                String displayName = ((NarrativeEntry)this.item).getName();
                guiGraphics.drawCenteredString(this.this$0.parentScreen.font, displayName, this.this$0.width / 2, y + 3, -1);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (CommonInputs.selected((int)keyCode)) {
                    this.select();
                    this.this$0.parentScreen.onClose();
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                this.select();
                return super.mouseClicked(mouseX, mouseY, button);
            }

            private void select() {
                this.this$0.setSelected((AbstractSelectionList.Entry)this);
            }

            public Component getNarration() {
                String displayName = ((NarrativeEntry)this.item).getName();
                return Component.literal((String)displayName);
            }
        }
    }
}

