/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.story;

import com.bladecoder.ink.runtime.Choice;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.keys.ModKeys;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.components.ChoiceButtonWidget;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class StoryChoicesScreen
extends Screen {
    private static final double APPEAR_TIME = 0.25;
    private static final int OFFSET = 10;
    private final List<Choice> choiceList;
    private final List<AnimatedChoice> animatedChoices;
    private final List<ChoiceButtonWidget> choiceButtonWidgetList = new ArrayList<ChoiceButtonWidget>();
    private final int totalTick;
    private PlayerSession playerSession;
    private StoryHandler storyHandler;
    private boolean initiated;
    private double t;
    private int currentTick;

    public StoryChoicesScreen(PlayerSession playerSession, boolean animate) {
        super((Component)Component.literal((String)"Choice screen"));
        this.playerSession = playerSession;
        this.storyHandler = playerSession.getStoryHandler();
        this.choiceList = playerSession.getStoryHandler().getStory().getCurrentChoices();
        this.animatedChoices = new ArrayList<AnimatedChoice>();
        this.initiated = !animate;
        this.totalTick = 5;
    }

    public StoryChoicesScreen(List<Choice> choiceList, boolean animate) {
        super((Component)Component.literal((String)"Choice screen"));
        this.choiceList = choiceList;
        this.animatedChoices = new ArrayList<AnimatedChoice>();
        this.initiated = !animate;
        this.totalTick = 5;
    }

    public static StoryChoicesScreen fromStrings(List<String> stringChoiceList) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (String choiceString : stringChoiceList) {
            Choice choice = new Choice();
            choice.setIndex(0);
            choice.setText(choiceString);
            choices.add(choice);
        }
        return new StoryChoicesScreen(choices, true);
    }

    public void tick() {
        super.tick();
        if (this.currentTick < this.totalTick) {
            ++this.currentTick;
        }
        for (ChoiceButtonWidget choiceButtonWidget : this.choiceButtonWidgetList) {
            choiceButtonWidget.tick();
        }
    }

    protected void init() {
        int i;
        if (!this.initiated) {
            ResourceLocation soundRes = ResourceLocation.withDefaultNamespace((String)"sfx.choice_appear");
            SoundEvent sound = SoundEvent.createVariableRangeEvent((ResourceLocation)soundRes);
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f, (float)1.0f));
        }
        this.choiceButtonWidgetList.clear();
        for (Choice choice : this.choiceList) {
            this.choiceButtonWidgetList.add(new ChoiceButtonWidget(choice, index -> {
                this.minecraft.setScreen(null);
                NarrativeCraftMod.server.execute(() -> this.storyHandler.chooseChoiceAndNext((int)index));
            }));
        }
        int spacing = 10;
        int baseY = 60;
        int maxWidthUpDown = 0;
        for (i = 0; i < this.choiceButtonWidgetList.size(); ++i) {
            if (i % 2 == 0 || this.choiceButtonWidgetList.get(i).getWidth() <= maxWidthUpDown) continue;
            maxWidthUpDown = this.choiceButtonWidgetList.get(i).getWidth();
        }
        for (i = 0; i < this.choiceButtonWidgetList.size(); ++i) {
            ChoiceButtonWidget choiceButtonWidget = this.choiceButtonWidgetList.get(i);
            choiceButtonWidget.setOpacity(5);
            choiceButtonWidget.setCanPress(false);
            int currentX = 0;
            int offsetX = 0;
            int offsetY = 0;
            int currentY = this.height - baseY;
            if (this.choiceButtonWidgetList.size() == 4) {
                currentY -= choiceButtonWidget.getHeight();
            }
            switch (i) {
                case 0: {
                    currentX = this.choiceButtonWidgetList.size() == 1 ? this.width / 2 - choiceButtonWidget.getWidth() / 2 : (this.choiceButtonWidgetList.size() > 2 ? this.width / 2 - choiceButtonWidget.getWidth() - maxWidthUpDown / 2 : this.width / 2 - choiceButtonWidget.getWidth() - spacing);
                    offsetX = 10;
                    break;
                }
                case 1: {
                    if (this.choiceButtonWidgetList.size() > 2) {
                        currentY -= choiceButtonWidget.getHeight() + spacing;
                        currentX = this.width / 2 - choiceButtonWidget.getWidth() / 2;
                        offsetY = 10;
                        break;
                    }
                    currentX = this.width / 2 + spacing;
                    offsetX = -10;
                    break;
                }
                case 2: {
                    currentX = this.width / 2 + maxWidthUpDown / 2;
                    offsetX = -10;
                    break;
                }
                case 3: {
                    currentY += choiceButtonWidget.getHeight() + spacing;
                    currentX = this.width / 2 - choiceButtonWidget.getWidth() / 2;
                    offsetY = -10;
                }
            }
            choiceButtonWidget.setX(currentX);
            choiceButtonWidget.setY(currentY);
            this.addRenderableWidget((GuiEventListener)choiceButtonWidget);
            AnimatedChoice animatedChoice = new AnimatedChoice(choiceButtonWidget, offsetX, offsetY);
            this.animatedChoices.add(animatedChoice);
        }
        if (!this.initiated) {
            this.t = 0.0;
            this.initiated = true;
        } else {
            this.t = 1.0;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return false;
        }
        if (this.storyHandler == null) {
            this.minecraft.setScreen(null);
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        List<KeyMapping> choiceKeys = List.of(ModKeys.SELECT_CHOICE_1, ModKeys.SELECT_CHOICE_2, ModKeys.SELECT_CHOICE_3, ModKeys.SELECT_CHOICE_4);
        for (int i = 0; i < this.storyHandler.getStory().getCurrentChoices().size(); ++i) {
            if (keyCode != choiceKeys.get(i).getDefaultKey().getValue()) continue;
            this.minecraft.setScreen(null);
            try {
                this.storyHandler.getStory().chooseChoiceIndex(i);
                continue;
            }
            catch (Exception e) {
                this.storyHandler.stop();
                Util.sendCrashMessage((Player)this.minecraft.player, e);
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.t = Math.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), 0.0, 1.0);
        for (AnimatedChoice ac : this.animatedChoices) {
            int newOpacity = (int)Mth.lerp((double)this.t, (double)5.0, (double)255.0);
            guiGraphics.pose().pushMatrix();
            if (this.choiceList.size() > 1) {
                guiGraphics.pose().translate((float)Mth.lerp((double)this.t, (double)ac.offsetX, (double)0.0), (float)Mth.lerp((double)this.t, (double)ac.offsetY, (double)0.0));
            }
            ac.widget.setOpacity(newOpacity);
            ac.widget.render(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.pose().popMatrix();
            if (!(this.t >= 1.0)) continue;
            ac.widget.setCanPress(true);
        }
    }

    protected void repositionElements() {
        this.animatedChoices.clear();
        super.repositionElements();
    }

    public void onClose() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(GuiGraphics guiGraphics) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private record AnimatedChoice(ChoiceButtonWidget widget, int offsetX, int offsetY) {
    }
}

