/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.api.inkAction;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.api.inkAction.InkActionUtil;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public abstract class InkAction {
    protected static final String MISS_ARGUMENT_TEXT = "ink_action.validation.miss_argument";
    protected static final String WRONG_ARGUMENT_TEXT = "ink_action.validation.wrong_argument";
    protected static final String WRONG_TIME_VALUE = "ink_action.validation.wrong_time_value";
    protected static final String WRONG_EASING_VALUE = "ink_action.validation.wrong_easing_value";
    protected static final String NOT_VALID_BOOLEAN = "ink_action.validation.boolean";
    protected static final String NOT_VALID_NUMBER = "ink_action.validation.number";
    protected static final String NOT_VALID_COLOR = "ink_action.validation.color";
    protected static final String NOT_VALID_INK = "ink_action.validation.not_validated";
    protected final String id;
    protected final String syntax;
    protected final Side side;
    protected final CommandMatcher matcher;
    protected boolean isRunning;
    protected boolean canBeExecuted = false;
    protected int tick;
    protected int totalTick;
    protected String command;
    protected Runnable blockEndTask;

    public InkAction(String id, Side side, String syntax, CommandMatcher matcher) {
        this.id = id;
        this.side = side;
        this.syntax = syntax;
        this.matcher = matcher;
    }

    public void tick() {
    }

    public void partialTick(float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
    }

    public void render(PoseStack poseStack, float partialTick) {
    }

    public void stop() {
    }

    public final InkActionResult validate(String command, Scene scene) {
        this.command = command;
        InkActionResult result = this.doValidate(InkActionUtil.getArguments(command), scene);
        if (!result.isError()) {
            this.canBeExecuted = true;
        }
        return result;
    }

    public final InkActionResult execute(PlayerSession playerSession) {
        if (!this.canBeExecuted) {
            return InkActionResult.error((Component)Translation.message(NOT_VALID_INK, new Object[0]));
        }
        this.isRunning = true;
        return this.doExecute(playerSession);
    }

    public InkActionResult validateAndExecute(String command, PlayerSession playerSession) {
        InkActionResult result = this.validate(command, playerSession.getScene());
        if (result.isError()) {
            return result;
        }
        return this.execute(playerSession);
    }

    protected abstract InkActionResult doValidate(List<String> var1, Scene var2);

    protected abstract InkActionResult doExecute(PlayerSession var1);

    public abstract boolean needScene();

    public String getId() {
        return this.id;
    }

    public Side getSide() {
        return this.side;
    }

    public CommandMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    public void setBlockEndTask(Runnable blockEndTask) {
        this.blockEndTask = blockEndTask;
    }

    public String getCommand() {
        return this.command;
    }

    public static enum Side {
        CLIENT,
        SERVER;

    }

    public static interface CommandMatcher {
        public boolean matches(String var1);
    }
}

