/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.StoryValidation;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class StoryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nc").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"story").then(Commands.m_82127_((String)"validate").executes(commandContext -> StoryCommand.validateStory((CommandContext<CommandSourceStack>)commandContext, true)))).then(Commands.m_82127_((String)"play").then(Commands.m_82129_((String)"chapter_index", (ArgumentType)IntegerArgumentType.integer()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getChapterSuggestions()).then(Commands.m_82129_((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSceneSuggestionsByChapter()).then(Commands.m_82129_((String)"debug", (ArgumentType)BoolArgumentType.bool()).executes(context -> StoryCommand.playStoryChapterStory((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"chapter_index"), StringArgumentType.getString((CommandContext)context, (String)"scene_name"), BoolArgumentType.getBool((CommandContext)context, (String)"debug")))))))).then(Commands.m_82127_((String)"stop").executes(StoryCommand::stopStory))));
    }

    private static int validateStory(CommandContext<CommandSourceStack> context, boolean fullValidation) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (fullValidation) {
            player.m_213846_((Component)Component.m_237119_());
            player.m_213846_((Component)Translation.message("validation.validating", new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
        try {
            List<ErrorLine> results = StoryValidation.validate();
            List<ErrorLine> warnLines = results.stream().filter(ErrorLine::isWarn).toList();
            List<ErrorLine> errorLines = results.stream().filter(errorLine -> !errorLine.isWarn()).toList();
            if (errorLines.isEmpty() && warnLines.isEmpty() && fullValidation) {
                player.m_213846_((Component)Translation.message("validation.validated", new Object[0]).m_130940_(ChatFormatting.GREEN));
                player.m_213846_((Component)Component.m_237119_());
                return 1;
            }
            for (ErrorLine errorLine2 : results) {
                player.m_213846_(errorLine2.toMessage());
            }
            if (!errorLines.isEmpty()) {
                player.m_213846_((Component)Translation.message("validation.found_errors", Component.m_237113_((String)String.valueOf(errorLines.size())).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.RED));
                player.m_213846_((Component)Component.m_237119_());
            }
            if (!warnLines.isEmpty()) {
                player.m_213846_((Component)Translation.message("validation.found_warns", Component.m_237113_((String)String.valueOf(warnLines.size())).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.YELLOW));
            }
            return errorLines.isEmpty() ? 1 : 0;
        }
        catch (Exception e) {
            Util.sendCrashMessage((Player)player, e);
            if (fullValidation) {
                player.m_213846_((Component)Component.m_237119_());
            }
            return 1;
        }
    }

    private static int playStoryChapterStory(CommandContext<CommandSourceStack> context, int chapterIndex, String sceneName, boolean debug) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).m_230896_());
        if (playerSession == null) {
            return 0;
        }
        if (!NarrativeCraftFile.getStoryFile().exists()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Translation.message("story.no_exists", new Object[0]));
            return 0;
        }
        Chapter chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(chapterIndex);
        if (chapter == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Translation.message("chapter.no_exists", chapterIndex));
            return 0;
        }
        Scene scene = chapter.getSceneByName(sceneName);
        if (scene == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Translation.message("scene.no_exists", sceneName, chapterIndex));
            return 0;
        }
        if (StoryCommand.validateStory(context, false) == 0) {
            return 0;
        }
        if (playerSession.getStoryHandler() != null) {
            playerSession.getStoryHandler().stop();
        }
        StoryHandler storyHandler = new StoryHandler(chapter, scene, playerSession);
        storyHandler.setDebugMode(debug);
        storyHandler.start();
        return 1;
    }

    private static int stopStory(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).m_6761_(2)) {
            return 0;
        }
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)((CommandSourceStack)context.getSource()).m_230896_());
        if (playerSession == null) {
            return 0;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Translation.message("story.not_playing", new Object[0]));
            return 0;
        }
        storyHandler.stop();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Translation.message("story.stopped", new Object[0]), false);
        return 1;
    }
}

