/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.keyframe;

import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractKeyframesBase<T extends Keyframe>
extends AbstractKeyframeController<T> {
    protected final List<T> keyframes = new ArrayList<T>();

    public AbstractKeyframesBase(Environment environment, Player player) {
        super(environment, player);
    }

    @Override
    public T getNextKeyframe(T toKeyframe) {
        for (int i = 0; i < this.keyframes.size() - 1; ++i) {
            if (((Keyframe)this.keyframes.get(i)).getId() != ((Keyframe)toKeyframe).getId()) continue;
            return (T)((Keyframe)this.keyframes.get(i + 1));
        }
        return toKeyframe;
    }

    @Override
    public T getPreviousKeyframe(T fromKeyframe) {
        for (int i = 0; i < this.keyframes.size(); ++i) {
            if (((Keyframe)this.keyframes.get(i)).getId() != ((Keyframe)fromKeyframe).getId()) continue;
            if (i == 0) {
                return fromKeyframe;
            }
            return (T)((Keyframe)this.keyframes.get(i - 1));
        }
        return fromKeyframe;
    }

    @Override
    public T getKeyframeByEntity(Entity entity) {
        for (Keyframe keyframe : this.keyframes) {
            if (!Util.isSameEntity(entity, (Entity)keyframe.getCamera())) continue;
            return (T)keyframe;
        }
        return null;
    }

    @Override
    public void hideKeyframes(ServerPlayer player) {
        for (Keyframe keyframe : this.keyframes) {
            keyframe.hideKeyframe(player);
        }
    }

    @Override
    public void showKeyframes(ServerPlayer player) {
        for (Keyframe keyframe : this.keyframes) {
            keyframe.showKeyframe(player);
        }
    }

    @Override
    public void removeKeyframe(T keyframe) {
        this.keyframes.remove(keyframe);
        ((Keyframe)keyframe).hideKeyframe(this.playerSession.getPlayer());
    }

    public List<T> getKeyframes() {
        return this.keyframes;
    }
}

