/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.CharacterInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.characters.CharacterOptionsScreen;
import fr.loudo.narrativecraft.screens.components.ButtonListScreen;
import fr.loudo.narrativecraft.screens.components.CharacterInteractionOptionsScreen;
import fr.loudo.narrativecraft.screens.components.InteractionOptionScreen;
import fr.loudo.narrativecraft.screens.keyframe.KeyframeTriggerScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OnEntityRightClick {
    public static void entityRightClick(Player player, Entity entity) {
        AbstractController controller;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer(player);
        if (playerSession == null) {
            return;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler != null) {
            storyHandler.interactWith(entity);
        }
        if ((controller = playerSession.getController()) == null) {
            return;
        }
        if (controller.getEnvironment() != Environment.DEVELOPMENT) {
            return;
        }
        CharacterRuntime characterRuntime = controller.getCharacterFromEntity(entity);
        if (controller instanceof AbstractKeyframeController) {
            AbstractKeyframeController keyframeController = (AbstractKeyframeController)controller;
            Object keyframe = keyframeController.getKeyframeByEntity(entity);
            keyframeController.setCamera((Keyframe)keyframe);
            KeyframeTrigger keyframeTrigger = keyframeController.getKeyframeTriggerByEntity(entity);
            if (keyframeTrigger != null) {
                KeyframeTriggerScreen screen = new KeyframeTriggerScreen((AbstractKeyframeController<? extends Keyframe>)keyframeController, keyframeTrigger);
                Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)screen));
            }
        }
        if (controller instanceof InteractionController) {
            ButtonListScreen screen;
            CharacterInteraction characterInteraction;
            InteractionController interactionController = (InteractionController)controller;
            if (characterRuntime != null && (characterInteraction = interactionController.getCharacterInteractionFromCharacter(interactionController.getCharacterStoryDataFromEntity((Entity)characterRuntime.getEntity()))) != null) {
                screen = new CharacterInteractionOptionsScreen(null, controller, characterRuntime, characterInteraction);
                Minecraft.m_91087_().execute(() -> OnEntityRightClick.lambda$entityRightClick$1((CharacterInteractionOptionsScreen)screen));
                return;
            }
            EntityInteraction entityInteraction = interactionController.getEntityInteraction(entity);
            if (entityInteraction != null) {
                screen = new InteractionOptionScreen(null, entityInteraction, interactionController);
                Minecraft.m_91087_().execute(() -> OnEntityRightClick.lambda$entityRightClick$2((InteractionOptionScreen)screen));
            }
        }
        if (characterRuntime != null) {
            CharacterOptionsScreen screen = new CharacterOptionsScreen(null, controller, characterRuntime);
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)screen));
        }
    }

    private static /* synthetic */ void lambda$entityRightClick$2(InteractionOptionScreen screen) {
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private static /* synthetic */ void lambda$entityRightClick$1(CharacterInteractionOptionsScreen screen) {
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }
}

