/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.CharacterInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class OnServerTick {
    public static void tick(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
            ArrayList<InkAction> toRemove = new ArrayList<InkAction>();
            List<InkAction> inkActionsServer = playerSession.getServerSideInkActions();
            for (InkAction inkAction : inkActionsServer) {
                if (!inkAction.isRunning()) {
                    toRemove.add(inkAction);
                }
                inkAction.tick();
            }
            playerSession.getInkActions().removeAll(toRemove);
            for (CharacterRuntime characterRuntime : playerSession.getCharacterRuntimes()) {
                server.m_6846_().m_11268_((Packet)new ClientboundRotateHeadPacket((Entity)characterRuntime.getEntity(), (byte)(characterRuntime.getEntity().m_6080_() * 256.0f / 360.0f)));
            }
            StoryHandler storyHandler = playerSession.getStoryHandler();
            KeyframeLocation location = playerSession.getCurrentCamera();
            if (location != null) {
                playerSession.getPlayer().f_8906_.m_9774_(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            }
            if (storyHandler == null || !playerSession.isOnGameplay() || playerSession.getCurrentCamera() != null) continue;
            Vec3 pPosition = playerSession.getPlayer().m_20182_();
            Object areaTriggerInside = null;
            for (InteractionController interactionController : playerSession.getInteractionControllers()) {
                for (AreaTrigger areaTrigger : interactionController.getAreaTriggers()) {
                    if (!AreaTrigger.isInside(areaTrigger, pPosition)) continue;
                    areaTriggerInside = areaTrigger;
                }
            }
            if (areaTriggerInside != null && !areaTriggerInside.equals(playerSession.getLastAreaTriggerEntered())) {
                if (((AreaTrigger)areaTriggerInside).isUnique() && playerSession.getAreaTriggersEntered().contains(areaTriggerInside)) continue;
                storyHandler.playStitch(((AreaTrigger)areaTriggerInside).getStitch());
                playerSession.addAreaTriggerEntered((AreaTrigger)areaTriggerInside);
                playerSession.setLastAreaTriggerEntered((AreaTrigger)areaTriggerInside);
            } else if (areaTriggerInside == null && playerSession.getLastAreaTriggerEntered() != null) {
                playerSession.setLastAreaTriggerEntered(null);
            }
            playerSession.setLookingAtEntityId(-1);
            for (InteractionController interactionController : playerSession.getInteractionControllers()) {
                for (CharacterInteraction characterInteraction : interactionController.getCharacterInteractions()) {
                    LivingEntity livingEntity;
                    if (characterInteraction.getStitch().isEmpty() || playerSession.getDialogRenderer() != null && playerSession.getLastInteraction() != null && playerSession.getLastInteraction().getStitch().equals(characterInteraction.getStitch()) || !(pPosition.m_82554_((livingEntity = characterInteraction.getCharacterStoryData().getCharacterRuntime().getEntity()).m_20182_()) <= 5.0) || !Util.isLookingAtMe((LivingEntity)player, livingEntity, 0.2, true, false, livingEntity.m_20186_() + (double)(livingEntity.m_20206_() / 2.0f))) continue;
                    playerSession.setLookingAtEntityId(livingEntity.m_19879_());
                }
                for (EntityInteraction entityInteraction : interactionController.getEntityInteractions()) {
                    if (entityInteraction.getStitch().isEmpty() || playerSession.getDialogRenderer() != null && playerSession.getLastInteraction() != null && playerSession.getLastInteraction().getStitch().equals(entityInteraction.getStitch()) || !(pPosition.m_82554_(entityInteraction.getArmorStand().m_20182_()) <= 5.0) || !Util.isLookingAtMe((LivingEntity)player, (LivingEntity)entityInteraction.getArmorStand(), 0.2, true, false, entityInteraction.getArmorStand().m_20186_() + (double)(entityInteraction.getArmorStand().m_20206_() / 2.0f))) continue;
                    playerSession.setLookingAtEntityId(entityInteraction.getArmorStand().m_19879_());
                }
            }
        }
    }
}

