/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.keys;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;

public class ModKeys {
    private static final Map<KeyMapping, Boolean> previousStatesKeyMapping = new HashMap<KeyMapping, Boolean>();
    private static final Map<Integer, Boolean> previousStatesKeyCode = new HashMap<Integer, Boolean>();
    private static final List<KeyMapping> ALL_KEYS = new ArrayList<KeyMapping>();
    public static final KeyMapping OPEN_STORY_MANAGER = ModKeys.registerKey("key.screen.story.open", 78);
    public static final KeyMapping START_ANIMATION_RECORDING = ModKeys.registerKey("key.animation.record.start", 86);
    public static final KeyMapping STOP_ANIMATION_RECORDING = ModKeys.registerKey("key.animation.record.stop", 66);
    public static final KeyMapping OPEN_CONTROLLER_SCREEN = ModKeys.registerKey("key.screen.keyframe_controller", 71);
    public static final KeyMapping NEXT_DIALOG = ModKeys.registerKey("key.dialog.next", 257);
    public static final KeyMapping SELECT_CHOICE_1 = ModKeys.registerKey("key.choice.1", 49);
    public static final KeyMapping SELECT_CHOICE_2 = ModKeys.registerKey("key.choice.2", 50);
    public static final KeyMapping SELECT_CHOICE_3 = ModKeys.registerKey("key.choice.3", 51);
    public static final KeyMapping SELECT_CHOICE_4 = ModKeys.registerKey("key.choice.4", 52);
    public static final KeyMapping STORY_DEBUG = ModKeys.registerKey("key.story_debug", 298);

    private static KeyMapping registerKey(String translationKey, int code) {
        KeyMapping key = new KeyMapping(translationKey, InputConstants.Type.KEYSYM, code, "key.categories.narrativecraft");
        ALL_KEYS.add(key);
        return key;
    }

    public static List<KeyMapping> getAllKeys() {
        return ALL_KEYS;
    }

    public static void handleKeyPress(KeyMapping key, Runnable action) {
        boolean isDown = key.m_90857_();
        boolean wasDown = previousStatesKeyMapping.getOrDefault(key, false);
        if (isDown && !wasDown) {
            action.run();
        }
        previousStatesKeyMapping.put(key, isDown);
    }

    public static void handleKeyPress(int code, boolean isDown, Runnable action) {
        boolean wasDown = previousStatesKeyCode.getOrDefault(code, false);
        if (isDown && !wasDown) {
            action.run();
        }
        previousStatesKeyCode.put(code, isDown);
    }
}

