/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.managers;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;

public class ChapterManager {
    private final List<Chapter> chapters = new ArrayList<Chapter>();

    public SuggestionProvider<CommandSourceStack> getChapterSuggestions() {
        return (context, builder) -> {
            for (Chapter chapter : this.chapters) {
                builder.suggest(chapter.getIndex());
            }
            return builder.buildFuture();
        };
    }

    public SuggestionProvider<CommandSourceStack> getSceneSuggestionsByChapter() {
        return (context, builder) -> {
            int chapterIndex = IntegerArgumentType.getInteger((CommandContext)context, (String)"chapter_index");
            Chapter chapter = this.getChapterByIndex(chapterIndex);
            if (chapter == null) {
                return builder.buildFuture();
            }
            for (Scene scene : chapter.getSortedSceneList()) {
                if (scene.getName().split(" ").length > 1) {
                    builder.suggest("\"" + scene.getName() + "\"");
                    continue;
                }
                builder.suggest(scene.getName());
            }
            return builder.buildFuture();
        };
    }

    public SuggestionProvider<CommandSourceStack> getSubscenesOfScenesSuggestions() {
        return (context, builder) -> {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.m_91087_().f_91074_);
            if (playerSession == null) {
                return builder.buildFuture();
            }
            if (!playerSession.isSessionSet()) {
                return builder.buildFuture();
            }
            for (Subscene subscene : playerSession.getScene().getSubscenes()) {
                if (subscene.getName().split(" ").length > 1) {
                    builder.suggest("\"" + subscene.getName() + "\"");
                    continue;
                }
                builder.suggest(subscene.getName());
            }
            return builder.buildFuture();
        };
    }

    public void addChapter(Chapter chapter) {
        if (this.chapters.contains(chapter)) {
            return;
        }
        this.chapters.add(chapter);
    }

    public void removeChapter(Chapter chapter) {
        this.chapters.remove(chapter);
    }

    public Chapter getChapterByName(String name) {
        for (Chapter chapter : this.chapters) {
            if (!chapter.getName().equalsIgnoreCase(name)) continue;
            return chapter;
        }
        return null;
    }

    public Chapter getChapterByIndex(int index) {
        for (Chapter chapter : this.chapters) {
            if (chapter.getIndex() != index) continue;
            return chapter;
        }
        return null;
    }

    public boolean chapterExists(String name) {
        for (Chapter chapter : this.chapters) {
            if (!chapter.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean chapterExists(int index) {
        for (Chapter chapter : this.chapters) {
            if (chapter.getIndex() != index) continue;
            return true;
        }
        return false;
    }

    public List<Chapter> getChapters() {
        return this.chapters;
    }
}

