/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import com.mojang.authlib.GameProfile;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.mixin.accessor.PlayerInfoAccessor;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.MainCharacterAttribute;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Util;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerMixin {
    @Shadow
    private PlayerInfo f_108546_;

    @Inject(method={"getPlayerInfo"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$getProfile(CallbackInfoReturnable<PlayerInfo> callbackInfo) {
        if (!"_username_".equals(this.f_108546_.m_105312_().getName())) {
            return;
        }
        GameProfile originalProfile = ((PlayerInfo)callbackInfo.getReturnValue()).m_105312_();
        String playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        callbackInfo.setReturnValue((Object)new PlayerInfo(new GameProfile(originalProfile.getId(), playerName), true));
    }

    @Inject(method={"getSkinTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void narrativecraft$getSkinOfCharacter(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation mainCharacterSkin;
        CharacterStory mainCharacter;
        if (this.f_108546_ == null) {
            return;
        }
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)Minecraft.m_91087_().f_91074_);
        if (playerSession == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_.m_36316_().equals((Object)this.f_108546_.m_105312_()) && playerSession.getStoryHandler() != null && (mainCharacter = NarrativeCraftMod.getInstance().getCharacterManager().getMainCharacter()) != null && mainCharacter.getMainCharacterAttribute().isSameSkinAsTheir() && (mainCharacterSkin = NarrativeCraftFile.getMainCharacterSkin()) != null) {
            ((PlayerInfoAccessor)this.f_108546_).setSkinModel(mainCharacter.getModel().name().toLowerCase());
            cir.setReturnValue((Object)mainCharacterSkin);
            return;
        }
        for (CharacterRuntime characterRuntime : new ArrayList<CharacterRuntime>(playerSession.getCharacterRuntimes())) {
            if (characterRuntime.getEntity() == null) continue;
            CharacterStory characterStory = characterRuntime.getCharacterStory();
            MainCharacterAttribute mainCharacterAttribute = characterStory.getMainCharacterAttribute();
            File currentSkinFile = characterRuntime.getCharacterSkinController().getCurrentSkin();
            if (currentSkinFile == null) continue;
            ResourceLocation skinLocation = new ResourceLocation("narrativecraft", "character/" + Util.snakeCase(characterStory.getName()) + "/" + Util.snakeCase(currentSkinFile.getName()));
            ((PlayerInfoAccessor)this.f_108546_).setSkinModel(characterRuntime.getCharacterStory().getModel().name().toLowerCase());
            if (!this.f_108546_.m_105312_().getName().equals(characterStory.getName())) continue;
            if (mainCharacterAttribute.isMainCharacter() && mainCharacterAttribute.isSameSkinAsPlayer()) {
                cir.setReturnValue((Object)Minecraft.m_91087_().f_91074_.m_108560_());
                return;
            }
            cir.setReturnValue((Object)skinLocation);
        }
    }
}

