/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;

public class Chapter
extends NarrativeEntry {
    private int index;
    private final List<Scene> scenes = new ArrayList<Scene>();

    public Chapter(String name, String description, int index) {
        super(name, description);
        this.index = index;
    }

    public String knotName() {
        return "chapter_" + this.index;
    }

    public void addScene(Scene scene) {
        if (this.scenes.contains(scene)) {
            return;
        }
        this.scenes.add(scene);
    }

    public void removeScene(Scene scene) {
        this.scenes.remove(scene);
        this.sortScenesByRank();
    }

    public Scene getSceneByName(String name) {
        for (Scene scene : this.scenes) {
            if (!scene.getName().equalsIgnoreCase(name)) continue;
            return scene;
        }
        return null;
    }

    public Scene getSceneByRank(int rank) {
        for (Scene scene : this.scenes) {
            if (scene.getRank() != rank) continue;
            return scene;
        }
        return null;
    }

    public boolean sceneExists(String name) {
        for (Scene scene : this.scenes) {
            if (!scene.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void setSceneRank(Scene scene, int newRank) {
        int oldRank = scene.getRank();
        if (newRank == oldRank) {
            return;
        }
        if (newRank < oldRank) {
            for (Scene s : this.scenes) {
                int r = s.getRank();
                if (r < newRank || r >= oldRank) continue;
                s.setRank(r + 1);
            }
        } else {
            for (Scene s : this.scenes) {
                int r = s.getRank();
                if (r > newRank || r <= oldRank) continue;
                s.setRank(r - 1);
            }
        }
        scene.setRank(newRank);
    }

    public SuggestionProvider<CommandSourceStack> getAnimationSuggestionFromScene(Scene scene) {
        return (context, builder) -> {
            for (Animation animation : scene.getAnimations()) {
                if (animation.getName().split(" ").length > 1) {
                    builder.suggest("\"" + animation.getName() + "\"");
                    continue;
                }
                builder.suggest(animation.getName());
            }
            return builder.buildFuture();
        };
    }

    public List<Scene> getSortedSceneList() {
        return this.scenes.stream().sorted(Comparator.comparingInt(Scene::getRank)).toList();
    }

    public List<Scene> getScenes() {
        return this.scenes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void sortScenesByRank() {
        List<Scene> sortedScenes = this.getSortedSceneList();
        for (int i = 0; i < sortedScenes.size(); ++i) {
            sortedScenes.get(i).setRank(i + 1);
        }
    }
}

