/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter.scene.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.SceneData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AreaTrigger
extends SceneData {
    private double x1;
    private double y1;
    private double z1;
    private double x2;
    private double y2;
    private double z2;
    private boolean isUnique;
    private String stitch;

    public AreaTrigger(String name, String description, Scene scene, String stitch, boolean isUnique) {
        super(name, description, scene);
        this.stitch = stitch;
        this.isUnique = isUnique;
    }

    public void setPosition1(Vec3 vec3) {
        this.x1 = Math.floor(vec3.m_7096_());
        this.y1 = Math.floor(vec3.m_7098_());
        this.z1 = Math.floor(vec3.m_7094_());
        if (this.x2 == 0.0 && this.y2 == 0.0 && this.z2 == 0.0) {
            this.x2 = Math.floor(vec3.m_7096_());
            this.y2 = Math.floor(vec3.m_7098_());
            this.z2 = Math.floor(vec3.m_7094_());
        }
    }

    public void setPosition2(Vec3 vec3) {
        this.x2 = Math.floor(vec3.m_7096_());
        this.y2 = Math.floor(vec3.m_7098_());
        this.z2 = Math.floor(vec3.m_7094_());
    }

    public AABB getBoundingBox() {
        double minX = Math.min(this.x1, this.x2);
        double minY = Math.min(this.y1, this.y2);
        double minZ = Math.min(this.z1, this.z2);
        double maxX = Math.max(this.x1, this.x2) + 1.0;
        double maxY = Math.max(this.y1, this.y2) + 1.0;
        double maxZ = Math.max(this.z1, this.z2) + 1.0;
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Vec3 getPosition1() {
        return new Vec3(this.x1, this.y1, this.z1);
    }

    public Vec3 getPosition2() {
        return new Vec3(this.x2, this.y2, this.z2);
    }

    public String getStitch() {
        return this.stitch;
    }

    public void setStitch(String stitch) {
        this.stitch = stitch;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }

    public void drawSquareLine(PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 camPos = camera.m_90583_();
        PoseStack.Pose matrix4f = poseStack.m_85850_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        VertexConsumer vertex = bufferSource.m_6299_(RenderType.m_110504_());
        double minX = Math.min(this.x1, this.x2);
        double minY = Math.min(this.y1, this.y2);
        double minZ = Math.min(this.z1, this.z2);
        double maxX = Math.max(this.x1, this.x2);
        double maxY = Math.max(this.y1, this.y2) + 1.0;
        double maxZ = Math.max(this.z1, this.z2);
        minX -= camPos.f_82479_;
        minY -= camPos.f_82480_;
        minZ -= camPos.f_82481_;
        maxX -= camPos.f_82479_;
        maxY -= camPos.f_82480_;
        maxZ -= camPos.f_82481_;
        Matrix4f matrix = matrix4f.m_252922_();
        float r = 0.09f;
        float g = 0.38f;
        float b = 0.85f;
        float a = 1.0f;
        Vec3 p000 = new Vec3(minX, minY, minZ);
        Vec3 p001 = new Vec3(minX, minY, maxZ);
        Vec3 p010 = new Vec3(minX, maxY, minZ);
        Vec3 p011 = new Vec3(minX, maxY, maxZ);
        Vec3 p100 = new Vec3(maxX, minY, minZ);
        Vec3 p101 = new Vec3(maxX, minY, maxZ);
        Vec3 p110 = new Vec3(maxX, maxY, minZ);
        Vec3 p111 = new Vec3(maxX, maxY, maxZ);
        this.drawEdge(vertex, matrix, p000, p100, r, g, b, a);
        this.drawEdge(vertex, matrix, p100, p101, r, g, b, a);
        this.drawEdge(vertex, matrix, p101, p001, r, g, b, a);
        this.drawEdge(vertex, matrix, p001, p000, r, g, b, a);
        this.drawEdge(vertex, matrix, p010, p110, r, g, b, a);
        this.drawEdge(vertex, matrix, p110, p111, r, g, b, a);
        this.drawEdge(vertex, matrix, p111, p011, r, g, b, a);
        this.drawEdge(vertex, matrix, p011, p010, r, g, b, a);
        this.drawEdge(vertex, matrix, p000, p010, r, g, b, a);
        this.drawEdge(vertex, matrix, p100, p110, r, g, b, a);
        this.drawEdge(vertex, matrix, p101, p111, r, g, b, a);
        this.drawEdge(vertex, matrix, p001, p011, r, g, b, a);
        bufferSource.m_109912_(RenderType.m_110504_());
    }

    private void drawEdge(VertexConsumer vertex, Matrix4f matrix, Vec3 a, Vec3 b, float r, float g, float bcol, float alpha) {
        vertex.m_252986_(matrix, (float)a.f_82479_, (float)a.f_82480_, (float)a.f_82481_).m_85950_(r, g, bcol, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertex.m_252986_(matrix, (float)b.f_82479_, (float)b.f_82480_, (float)b.f_82481_).m_85950_(r, g, bcol, alpha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static boolean isInside(AreaTrigger areaTrigger, Vec3 pPosition) {
        Vec3 pos1 = areaTrigger.getPosition1();
        Vec3 pos2 = areaTrigger.getPosition2();
        double minX = Math.min(pos1.f_82479_, pos2.f_82479_);
        double maxX = Math.max(pos1.f_82479_, pos2.f_82479_);
        double minY = Math.min(pos1.f_82480_, pos2.f_82480_);
        double maxY = Math.max(pos1.f_82480_, pos2.f_82480_);
        double minZ = Math.min(pos1.f_82481_, pos2.f_82481_);
        double maxZ = Math.max(pos1.f_82481_, pos2.f_82481_);
        return pPosition.f_82479_ >= minX && pPosition.f_82479_ <= maxX && pPosition.f_82480_ >= minY && pPosition.f_82480_ <= maxY && pPosition.f_82481_ >= minZ && pPosition.f_82481_ <= maxZ;
    }
}

