/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.geometric.DialogTail;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Position2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class DialogRenderer3D
extends DialogRenderer {
    private final DialogTail dialogTail;
    private final String characterName;
    private DialogEntityBobbing dialogEntityBobbing;
    private Position2D dialogOffset;
    private CharacterRuntime characterRuntime;
    private Vec3 dialogPosition;

    public DialogRenderer3D(String text, String characterName, CharacterRuntime characterRuntime, Position2D dialogOffset, float width, float paddingX, float paddingY, float scale, float letterSpacing, float gap, int backgroundColor, int textColor) {
        super(text, width, paddingX, paddingY, scale, letterSpacing, gap, backgroundColor, textColor);
        this.characterName = characterName;
        this.characterRuntime = characterRuntime;
        this.dialogOffset = dialogOffset;
        this.dialogTail = new DialogTail(this, 5.0f, 10.0f, 0.0f);
    }

    public DialogRenderer3D(String text, String characterName, DialogData dialogData, CharacterRuntime characterRuntime) {
        super(text, dialogData);
        this.characterName = characterName;
        this.characterRuntime = characterRuntime;
        this.dialogOffset = dialogData.getOffset();
        this.dialogTail = new DialogTail(this, 5.0f, 10.0f, 0.0f);
    }

    @Override
    public void tick() {
        if (this.dialogPosition == null) {
            return;
        }
        this.dialogEntityBobbing.tick();
        super.tick();
    }

    private void updateDialogPosition(float partialTick) {
        Entity entity;
        LivingEntity serverEntity = this.characterRuntime.getEntity();
        if (serverEntity != null && (entity = this.minecraft.f_91073_.m_6815_(this.characterRuntime.getEntity().m_19879_())) != null) {
            if (this.dialogPosition != null) {
                Vec3 newPos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
                double x = Mth.m_14139_((double)partialTick, (double)this.dialogPosition.f_82479_, (double)newPos.f_82479_);
                double y = Mth.m_14139_((double)partialTick, (double)this.dialogPosition.f_82480_, (double)newPos.f_82480_);
                double z = Mth.m_14139_((double)partialTick, (double)this.dialogPosition.f_82481_, (double)newPos.f_82481_);
                this.dialogPosition = new Vec3(x, y, z);
            } else {
                this.dialogPosition = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
            }
        }
    }

    @Override
    public void render(PoseStack poseStack, float partialTick) {
        this.updateDialogPosition(partialTick);
        if (this.dialogPosition == null) {
            return;
        }
        Vec3 position = this.dialogPosition;
        position = this.translateToRelativeApplyOffset(position);
        float originalScale = this.scale;
        if (this.currentTick < this.totalTick) {
            double t = this.t(partialTick);
            t = Easing.SMOOTH.interpolate(t);
            if (this.dialogStarting || this.dialogStopping) {
                double opacity;
                if (this.dialogStarting) {
                    originalScale = (float)Mth.m_14139_((double)t, (double)0.0, (double)this.scale);
                    opacity = Mth.m_14139_((double)t, (double)0.0, (double)1.0);
                    position = this.getDialogInterpolatedAppearPosition(t);
                } else {
                    originalScale = (float)Mth.m_14139_((double)t, (double)this.scale, (double)0.0);
                    opacity = Mth.m_14139_((double)t, (double)1.0, (double)0.0);
                    position = this.getDialogInterpolatedDisappearPosition(t);
                }
                this.backgroundColor = FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.backgroundColor);
            } else {
                originalScale = (float)Mth.m_14139_((double)t, (double)this.oldScale, (double)this.scale);
            }
        }
        if (this.currentTick == this.totalTick) {
            if (this.dialogStopping && !this.dialogStarting) {
                this.dialogStopping = false;
            }
            if (this.dialogStarting && !this.dialogStopping) {
                this.dialogStarting = false;
            }
        }
        VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(NarrativeCraftMod.dialogBackgroundRenderType);
        poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        poseStack.m_252781_(this.minecraft.m_91290_().m_253208_());
        poseStack.m_85841_(-(originalScale * 0.025f), -(originalScale * 0.025f), originalScale * 0.025f);
        this.renderDialogBackground(poseStack, partialTick);
        Side side = this.dialogOffsetSide();
        poseStack.m_85836_();
        if (side == Side.DOWN) {
            poseStack.m_252880_(0.0f, this.dialogOffset.x == 0.0f ? this.height : this.height / 2.0f + this.paddingY / 2.0f, 0.0f);
        }
        this.dialogTail.render(poseStack, partialTick, consumer, this.minecraft.f_91063_.m_109153_());
        poseStack.m_85849_();
        if (this.dialogOffset.y == 0.0f) {
            switch (side) {
                case RIGHT: 
                case LEFT: {
                    poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                }
            }
        }
        poseStack.m_85836_();
        if (side == Side.RIGHT) {
            if (this.dialogOffset.y == 0.0f) {
                poseStack.m_252880_(this.totalWidth, this.totalHeight / 2.0f, 0.0f);
            } else if (this.dialogOffset.y > 0.0f) {
                poseStack.m_252880_(this.totalWidth, 0.0f, 0.0f);
            } else if (this.dialogOffset.y < 0.0f) {
                poseStack.m_252880_(this.totalWidth, this.totalHeight, 0.0f);
            }
        } else if (side == Side.LEFT) {
            if (this.dialogOffset.y == 0.0f) {
                poseStack.m_252880_(-this.totalWidth, this.totalHeight / 2.0f, 0.0f);
            } else if (this.dialogOffset.y > 0.0f) {
                poseStack.m_252880_(-this.totalWidth, 0.0f, 0.0f);
            } else if (this.dialogOffset.y < 0.0f) {
                poseStack.m_252880_(-this.totalWidth, this.totalHeight, 0.0f);
            }
        } else if (side == Side.DOWN) {
            poseStack.m_252880_(0.0f, this.totalHeight, 0.0f);
        }
        if (!this.dialogStopping) {
            this.dialogEntityBobbing.partialTick(partialTick);
            this.dialogScrollTextDialog.render(poseStack, this.minecraft.m_91269_().m_110104_(), partialTick);
            if (this.dialogScrollTextDialog.isFinished()) {
                if (!this.dialogAutoSkipping) {
                    this.dialogAutoSkipping = true;
                    this.currentTick = 0;
                }
                this.dialogArrowSkip.start();
            }
            if (!this.noSkip) {
                VertexConsumer consumer1 = this.minecraft.m_91269_().m_110104_().m_6299_(NarrativeCraftMod.dialogBackgroundRenderType);
                this.dialogArrowSkip.render(poseStack, consumer1, partialTick);
                this.minecraft.m_91269_().m_110104_().m_109912_(NarrativeCraftMod.dialogBackgroundRenderType);
            }
        }
        poseStack.m_85849_();
        this.minecraft.m_91269_().m_110104_().m_109912_(NarrativeCraftMod.dialogBackgroundRenderType);
    }

    public void updateBobbing(float value1, float value2) {
        this.dialogEntityBobbing.setNoiseShakeSpeed(value1);
        this.dialogEntityBobbing.setNoiseShakeStrength(value2);
    }

    private Vec3 getDialogInterpolatedAppearPosition(double t) {
        Vec3 dialogPos = this.translateToRelative(this.dialogPosition);
        Vec3 dialogPositionOffsetApplied = this.translateToRelativeApplyOffset(this.dialogPosition);
        double x = Mth.m_14139_((double)t, (double)dialogPos.f_82479_, (double)dialogPositionOffsetApplied.f_82479_);
        double y = Mth.m_14139_((double)t, (double)dialogPos.f_82480_, (double)dialogPositionOffsetApplied.f_82480_);
        double z = Mth.m_14139_((double)t, (double)dialogPos.f_82481_, (double)dialogPositionOffsetApplied.f_82481_);
        return new Vec3(x, y, z);
    }

    private Vec3 getDialogInterpolatedDisappearPosition(double t) {
        Vec3 dialogPos = this.translateToRelative(this.dialogPosition);
        Vec3 dialogPositionOffsetApplied = this.translateToRelativeApplyOffset(this.dialogPosition);
        double x = Mth.m_14139_((double)t, (double)dialogPositionOffsetApplied.f_82479_, (double)dialogPos.f_82479_);
        double y = Mth.m_14139_((double)t, (double)dialogPositionOffsetApplied.f_82480_, (double)dialogPos.f_82480_);
        double z = Mth.m_14139_((double)t, (double)dialogPositionOffsetApplied.f_82481_, (double)dialogPos.f_82481_);
        return new Vec3(x, y, z);
    }

    private void renderDialogBackground(PoseStack poseStack, float partialTick) {
        MultiBufferSource.BufferSource bufferSource = this.minecraft.m_91269_().m_110104_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Side side = this.dialogOffsetSide();
        double diffY = this.translateToRelativeApplyOffset((Vec3)this.dialogPosition).f_82480_ - this.translateToRelative((Vec3)this.dialogPosition).f_82480_;
        float originalWidth = this.totalWidth;
        float originalHeight = this.totalHeight;
        if (this.isAnimating() && !this.dialogStarting && !this.dialogStopping) {
            originalWidth = this.getInterpolatedWidth(partialTick);
            originalHeight = this.getInterpolatedHeight(partialTick);
        } else {
            this.oldTotalWidth = this.totalWidth;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            this.oldTotalHeight = this.totalHeight;
            this.oldScale = this.scale;
        }
        switch (side) {
            case UP: {
                vertexConsumer.m_252986_(matrix4f, -originalWidth, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, originalWidth, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, originalWidth, -originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, -originalWidth, -originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                break;
            }
            case RIGHT: {
                if (diffY < 0.0) {
                    vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, 0.0f, originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, originalWidth * 2.0f, originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, originalWidth * 2.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    break;
                }
                if (diffY > 0.0) {
                    vertexConsumer.m_252986_(matrix4f, 0.0f, -originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, originalWidth * 2.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, originalWidth * 2.0f, -originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    break;
                }
                vertexConsumer.m_252986_(matrix4f, 0.0f, -originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, 0.0f, originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, originalWidth * 2.0f, originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, originalWidth * 2.0f, -originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                break;
            }
            case LEFT: {
                if (diffY < 0.0) {
                    vertexConsumer.m_252986_(matrix4f, -originalWidth * 2.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, -originalWidth * 2.0f, originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, 0.0f, originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    break;
                }
                if (diffY > 0.0) {
                    vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, 0.0f, -originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, -originalWidth * 2.0f, -originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    vertexConsumer.m_252986_(matrix4f, -originalWidth * 2.0f, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                    break;
                }
                vertexConsumer.m_252986_(matrix4f, 0.0f, originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, 0.0f, -originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, -originalWidth * 2.0f, -originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, -originalWidth * 2.0f, originalHeight / 2.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                break;
            }
            case DOWN: {
                vertexConsumer.m_252986_(matrix4f, -originalWidth, originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, originalWidth, originalHeight, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, originalWidth, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
                vertexConsumer.m_252986_(matrix4f, -originalWidth, 0.0f, 0.0f).m_193479_(this.backgroundColor).m_5752_();
            }
        }
    }

    private Side dialogOffsetSide() {
        Vec3 dialogPos = this.translateToRelative(this.dialogPosition);
        Vec3 dialogPosOffset = this.translateToRelativeApplyOffset(this.dialogPosition);
        double offsetX = 0.0;
        double offsetY = dialogPosOffset.f_82480_ - dialogPos.f_82480_;
        Direction direction = this.minecraft.f_91074_.m_6350_();
        if (direction == Direction.EAST) {
            offsetX = dialogPosOffset.f_82481_ - dialogPos.f_82481_;
        } else if (direction == Direction.WEST) {
            offsetX = dialogPos.f_82481_ - dialogPosOffset.f_82481_;
        } else if (direction == Direction.NORTH) {
            offsetX = dialogPosOffset.f_82479_ - dialogPos.f_82479_;
        } else if (direction == Direction.SOUTH) {
            offsetX = dialogPos.f_82479_ - dialogPosOffset.f_82479_;
        }
        if (offsetY >= 0.0 && offsetX >= 0.0 && offsetX <= 0.0) {
            return Side.UP;
        }
        if (offsetY <= 0.0 && offsetX >= 0.0 && offsetX <= 0.0) {
            return Side.DOWN;
        }
        if (offsetX <= 0.0) {
            return Side.LEFT;
        }
        if (offsetX >= 0.0) {
            return Side.RIGHT;
        }
        return Side.UP;
    }

    public Vec3 translateToRelative(Vec3 worldPos) {
        Vec3 camPos = this.minecraft.f_91063_.m_109153_().m_90583_();
        return new Vec3(worldPos.f_82479_ - camPos.f_82479_, worldPos.f_82480_ - camPos.f_82480_, worldPos.f_82481_ - camPos.f_82481_);
    }

    public Vec3 translateToRelativeApplyOffset(Vec3 position) {
        position = this.translateToRelative(position);
        double offsetX = 0.0;
        double offsetZ = 0.0;
        switch (this.minecraft.f_91074_.m_6350_()) {
            case EAST: {
                offsetZ = this.dialogOffset.x;
                break;
            }
            case WEST: {
                offsetZ = -this.dialogOffset.x;
                break;
            }
            case SOUTH: {
                offsetX = -this.dialogOffset.x;
                break;
            }
            case NORTH: {
                offsetX = this.dialogOffset.x;
            }
        }
        return new Vec3(position.f_82479_ + offsetX, position.f_82480_ + (double)this.dialogOffset.y, position.f_82481_ + offsetZ);
    }

    public CharacterRuntime getCharacterRuntime() {
        return this.characterRuntime;
    }

    public void setCharacterRuntime(CharacterRuntime characterRuntime) {
        this.characterRuntime = characterRuntime;
    }

    public Position2D getDialogOffset() {
        return this.dialogOffset;
    }

    public void setDialogOffset(Position2D dialogOffset) {
        this.dialogOffset = dialogOffset;
    }

    public Vec3 getDialogPosition() {
        return this.dialogPosition;
    }

    public Vec3 getDialogPositionWithOffset() {
        return this.dialogPosition.m_82520_((double)this.dialogOffset.x, this.dialogPosition.f_82480_, this.dialogPosition.f_82481_);
    }

    public String getCharacterName() {
        return this.characterName;
    }

    public DialogEntityBobbing getDialogEntityBobbing() {
        return this.dialogEntityBobbing;
    }

    public void setDialogEntityBobbing(DialogEntityBobbing dialogEntityBobbing) {
        this.dialogEntityBobbing = dialogEntityBobbing;
    }

    public static enum Side {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

