/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.util.Easing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class DialogArrowSkip {
    private final double translateTime = 0.4;
    private final DialogRenderer dialogRenderer;
    private float width;
    private float height;
    private float offset;
    private float xTranslatePoint;
    private int color;
    private int currentTick;
    private int totalTick;
    private boolean isRunning = false;

    public DialogArrowSkip(DialogRenderer dialogRenderer, float width, float height, float xTranslatePoint, float offset, int color) {
        this.dialogRenderer = dialogRenderer;
        this.width = width;
        this.height = height;
        this.xTranslatePoint = xTranslatePoint;
        this.offset = offset;
        this.color = FastColor.ABGR32.m_266498_((int)204, (int)color);
        this.totalTick = 8;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.currentTick = 0;
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void tick() {
        if (this.currentTick < this.totalTick && this.isRunning) {
            ++this.currentTick;
        }
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, float partialTick) {
        if (!this.isRunning) {
            return;
        }
        double translateX = -this.dialogRenderer.getPaddingX() * 2.0f + this.offset;
        int originalColor = this.color;
        if (this.currentTick < this.totalTick) {
            double t = Mth.m_14008_((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
            t = Easing.SMOOTH.interpolate(t);
            translateX = Mth.m_14139_((double)t, (double)(translateX + (double)this.xTranslatePoint), (double)translateX);
            double opacity = Mth.m_14139_((double)t, (double)0.0, (double)0.8);
            originalColor = FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.color);
        }
        poseStack.m_85837_(translateX, 0.0, 0.0);
        this.draw(poseStack, consumer, originalColor);
    }

    private void draw(PoseStack poseStack, VertexConsumer consumer, int color) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float xStart = this.dialogRenderer.getTotalWidth() - this.width - this.offset;
        float xEnd = this.dialogRenderer.getTotalWidth() + this.width - this.offset;
        consumer.m_252986_(matrix4f, xStart, -this.height, 0.01f).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix4f, xStart, this.height, 0.01f).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix4f, xEnd, 0.0f, 0.01f).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix4f, xStart, -this.height, 0.01f).m_193479_(color).m_5752_();
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        double translateX = 0.0;
        double opacity = this.isRunning ? 1.0 : 0.0;
        poseStack.m_85836_();
        if (this.currentTick < this.totalTick) {
            double t = Mth.m_14008_((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
            t = Easing.SMOOTH.interpolate(t);
            translateX = Mth.m_14139_((double)t, (double)this.xTranslatePoint, (double)translateX);
            opacity = Mth.m_14139_((double)t, (double)0.0, (double)1.0);
        }
        poseStack.m_252880_((float)translateX + this.offset, 0.0f, 0.0f);
        VertexConsumer consumer = guiGraphics.m_280091_().m_6299_(RenderType.m_285907_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        consumer.m_252986_(matrix4f, -this.width, -this.height, 0.01f).m_193479_(FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.color)).m_5752_();
        consumer.m_252986_(matrix4f, -this.width, this.height, 0.01f).m_193479_(FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.color)).m_5752_();
        consumer.m_252986_(matrix4f, this.width, 0.0f, 0.01f).m_193479_(FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.color)).m_5752_();
        consumer.m_252986_(matrix4f, -this.width, -this.height, 0.01f).m_193479_(FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.color)).m_5752_();
        poseStack.m_85849_();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOffset() {
        return this.offset;
    }

    public int getColor() {
        return this.color;
    }
}

