/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer2D;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import fr.loudo.narrativecraft.narrative.dialog.animation.AbstractDialogScrollText;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import org.joml.Vector2f;

public class DialogScrollTextDialog
extends AbstractDialogScrollText {
    private final DialogRenderer dialogRenderer;

    public DialogScrollTextDialog(DialogRenderer dialogRenderer, Minecraft minecraft) {
        super(minecraft);
        this.dialogRenderer = dialogRenderer;
        this.setText(dialogRenderer.getText());
        NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
        this.textSpeed = clientOption.textSpeed;
        this.letterSpacing = dialogRenderer.getLetterSpacing();
        this.gap = dialogRenderer.getGap();
        this.textColor = dialogRenderer.getTextColor();
    }

    @Override
    protected List<String> splitTextIntoLines(String text) {
        return Util.splitText(text, this.minecraft.f_91062_, (int)this.dialogRenderer.getWidth());
    }

    @Override
    protected float getInitialX() {
        return -this.dialogRenderer.getTotalWidth() + this.dialogRenderer.getPaddingX() * 2.0f;
    }

    @Override
    protected float getInitialY() {
        if (this.dialogRenderer instanceof DialogRenderer2D) {
            if (this.lines.size() > 1) {
                Objects.requireNonNull(this.minecraft.f_91062_);
                float f = (9.0f + this.dialogRenderer.getGap()) * (float)(this.lines.size() - 1);
                Objects.requireNonNull(this.minecraft.f_91062_);
                return -((f + 9.0f) / 2.0f + 0.7f);
            }
            Objects.requireNonNull(this.minecraft.f_91062_);
            return (float)(-9) / 2.0f;
        }
        return -this.dialogRenderer.getTotalHeight() + this.dialogRenderer.getPaddingY() + 0.7f;
    }

    @Override
    protected boolean canScroll() {
        return !this.dialogRenderer.isAnimating();
    }

    public void render(PoseStack poseStack, MultiBufferSource.BufferSource source, float partialTick) {
        Map<Integer, Vector2f> offsets = this.getTextEffectOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            AbstractDialogScrollText.LetterLocation letter = (AbstractDialogScrollText.LetterLocation)this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x();
            float y = letter.y();
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            this.minecraft.f_91062_.m_271703_(String.valueOf(letter.letter()), x, y, FastColor.ABGR32.m_266498_((int)255, (int)this.textColor), false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)this.minecraft.m_91269_().m_110104_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        }
        source.m_109911_();
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        Map<Integer, Vector2f> offsets = this.getTextEffectOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            AbstractDialogScrollText.LetterLocation letter = (AbstractDialogScrollText.LetterLocation)this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x();
            float y = letter.y();
            DialogRenderer dialogRenderer = this.dialogRenderer;
            if (dialogRenderer instanceof DialogRenderer3D) {
                DialogRenderer3D dialogRenderer3D = (DialogRenderer3D)dialogRenderer;
                if (dialogRenderer3D.getDialogOffset().y < 0.0f) {
                    y += dialogRenderer3D.getTotalHeight() - dialogRenderer3D.getPaddingY();
                }
            }
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            this.minecraft.f_91062_.m_271703_(String.valueOf(letter.letter()), x, y, FastColor.ABGR32.m_266498_((int)255, (int)this.textColor), false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)this.minecraft.m_91269_().m_110104_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        }
    }
}

