/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.geometric;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class DialogTail {
    private final DialogRenderer3D dialog;
    private float width;
    private float height;
    private float offset;

    public DialogTail(DialogRenderer3D dialog, float width, float height, float offset) {
        this.dialog = dialog;
        this.width = width;
        this.height = height;
        this.offset = offset;
    }

    public void render(PoseStack poseStack, float partialTick, VertexConsumer consumer, Camera camera) {
        TailDirection tailDirection = TailDirection.TOP;
        if (this.dialog.getDialogOffset().x > 0.0f) {
            tailDirection = TailDirection.LEFT;
        } else if (this.dialog.getDialogOffset().x < 0.0f) {
            tailDirection = TailDirection.RIGHT;
        } else if (this.dialog.getDialogOffset().y > 0.0f) {
            tailDirection = TailDirection.BOTTOM;
        }
        Vec2 tailOffset = this.getTailOffset(camera);
        poseStack.m_85836_();
        if (this.dialog.getDialogOffset().x != 0.0f) {
            if (this.dialog.getDialogOffset().y < 0.0f) {
                poseStack.m_252880_(0.0f, this.height / 2.0f - this.width / 2.0f, 0.0f);
            } else if (this.dialog.getDialogOffset().y > 0.0f) {
                poseStack.m_252880_(0.0f, -(this.height / 2.0f) + this.width / 2.0f, 0.0f);
            }
        }
        if (tailDirection == TailDirection.RIGHT || tailDirection == TailDirection.LEFT) {
            float halfHeight = this.dialog.getHeight() / 2.0f;
            float minY = -halfHeight + this.width / 2.0f;
            float maxY = halfHeight - this.width / 2.0f;
            if (this.dialog.getDialogOffset().y != 0.0f) {
                if (tailOffset.f_82471_ < minY) {
                    tailDirection = TailDirection.valueOf(tailDirection.name() + "_UP_CORNER");
                } else if (tailOffset.f_82471_ > maxY) {
                    tailDirection = TailDirection.valueOf(tailDirection.name() + "_DOWN_CORNER");
                }
            }
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float topRight = -this.width / 2.0f + this.offset;
        float topLeft = this.width / 2.0f + this.offset;
        switch (tailDirection) {
            case TOP: {
                this.drawTailTop(matrix4f, consumer, topRight, topLeft);
                break;
            }
            case BOTTOM: {
                this.drawTailBottom(matrix4f, consumer, topRight, topLeft);
                break;
            }
            case RIGHT: {
                this.drawTailRight(matrix4f, consumer);
                break;
            }
            case RIGHT_UP_CORNER: {
                this.drawTailUpRightCorner(matrix4f, consumer);
                break;
            }
            case RIGHT_DOWN_CORNER: {
                this.drawTailDownRightCorner(matrix4f, consumer);
                break;
            }
            case LEFT: {
                this.drawTailLeft(matrix4f, consumer);
                break;
            }
            case LEFT_UP_CORNER: {
                this.drawTailUpLeftCorner(matrix4f, consumer);
                break;
            }
            case LEFT_DOWN_CORNER: {
                this.drawTailDownLeftCorner(matrix4f, consumer);
            }
        }
        poseStack.m_85849_();
    }

    public Vec2 getTailOffset(Camera camera) {
        Vec3 entityPos = this.dialog.translateToRelative(this.dialog.getDialogPosition());
        Vec3 dialogPos = this.dialog.translateToRelativeApplyOffset(this.dialog.getDialogPosition());
        Vec3 toDialog = dialogPos.m_82546_(entityPos);
        Vec3 camRight = new Vec3(camera.m_252775_()).m_82490_(-1.0);
        Vec3 camUp = new Vec3(camera.m_253028_());
        float scale = this.dialog.getScale() * 0.025f;
        return new Vec2((float)(toDialog.m_82526_(camRight) / (double)scale), (float)(toDialog.m_82526_(camUp) / (double)scale));
    }

    void drawTailTop(Matrix4f matrix4f, VertexConsumer buffer, float topRight, float topLeft) {
        buffer.m_252986_(matrix4f, 0.0f, -this.dialog.getHeight() - this.height, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -topRight, -this.dialog.getHeight(), 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -topLeft, -this.dialog.getHeight(), 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -topRight, -this.dialog.getHeight(), 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailBottom(Matrix4f matrix4f, VertexConsumer buffer, float topRight, float topLeft) {
        buffer.m_252986_(matrix4f, -topRight, 0.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -topLeft, 0.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, this.height, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -topRight, 0.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailLeft(Matrix4f matrix4f, VertexConsumer buffer) {
        buffer.m_252986_(matrix4f, -this.height, 0.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailRight(Matrix4f matrix4f, VertexConsumer buffer) {
        buffer.m_252986_(matrix4f, this.height, 0.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailUpRightCorner(Matrix4f matrix4f, VertexConsumer buffer) {
        buffer.m_252986_(matrix4f, this.height / 2.0f, -4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -this.width, -this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, this.height / 2.0f, -4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailDownRightCorner(Matrix4f matrix4f, VertexConsumer buffer) {
        buffer.m_252986_(matrix4f, this.height / 2.0f, 4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -this.width, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, this.height / 2.0f, 4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailUpLeftCorner(Matrix4f matrix4f, VertexConsumer buffer) {
        buffer.m_252986_(matrix4f, -this.height / 2.0f, -4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, this.width, -this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -this.height / 2.0f, -4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    void drawTailDownLeftCorner(Matrix4f matrix4f, VertexConsumer buffer) {
        buffer.m_252986_(matrix4f, -this.height / 2.0f, 4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, this.width, this.width / 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, this.width, -this.width * 2.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
        buffer.m_252986_(matrix4f, -this.height / 2.0f, 4.0f, 0.0f).m_193479_(this.dialog.getBackgroundColor()).m_5752_();
    }

    static enum TailDirection {
        TOP,
        BOTTOM,
        LEFT,
        LEFT_UP_CORNER,
        LEFT_DOWN_CORNER,
        RIGHT,
        RIGHT_UP_CORNER,
        RIGHT_DOWN_CORNER;

    }
}

