/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.interaction;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class InteractionEyeRenderer {
    private static final double APPEAR_TIME = 0.15;
    private static final float BASE_SCALE = 0.025f;
    private static final float SIZE = 10.0f;
    private static final int MAX_OPACITY = 255;
    private static int currentTick;
    private static Vec3 position;
    private static boolean isWatching;
    private static int lastEntityId;

    public static void tick() {
        int maxTick;
        if ((currentTick += isWatching ? 1 : -1) > (maxTick = 3)) {
            currentTick = maxTick;
        }
        if (currentTick < 0) {
            currentTick = 0;
        }
    }

    public static void render(PoseStack poseStack, float partialTick, int entityId) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.f_91073_.m_6815_(entityId);
        Vec3 camPos = mc.f_91063_.m_109153_().m_90583_();
        boolean bl = isWatching = entity != null;
        if (entityId != -1 && lastEntityId != entityId) {
            currentTick = 0;
        }
        if (isWatching) {
            position = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            lastEntityId = entityId;
        }
        if (position == null || currentTick == 0 && !isWatching) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(InteractionEyeRenderer.position.f_82479_ - camPos.f_82479_, InteractionEyeRenderer.position.f_82480_ - camPos.f_82480_, InteractionEyeRenderer.position.f_82481_ - camPos.f_82481_);
        poseStack.m_252781_(mc.m_91290_().f_114358_.m_253121_());
        int totalTick = 3;
        double t = ((double)currentTick + (isWatching ? (double)partialTick : 1.0 - (double)partialTick)) / (double)totalTick;
        t = Easing.SMOOTH.interpolate(Mth.m_14008_((double)t, (double)0.0, (double)1.0));
        float scale = (float)((double)0.025f * t);
        int opacity = (int)(255.0 * t);
        poseStack.m_85841_(-scale, -scale, scale);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VertexConsumer vc = bufferSource.m_6299_(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        vc.m_252986_(mat, -10.0f, 10.0f, -1.0f).m_6122_(0, 0, 0, opacity).m_5752_();
        vc.m_252986_(mat, 10.0f, 10.0f, -1.0f).m_6122_(0, 0, 0, opacity).m_5752_();
        vc.m_252986_(mat, 10.0f, -10.0f, -1.0f).m_6122_(0, 0, 0, opacity).m_5752_();
        vc.m_252986_(mat, -10.0f, -10.0f, -1.0f).m_6122_(0, 0, 0, opacity).m_5752_();
        Font font = mc.f_91062_;
        float f = (float)(-mc.f_91062_.m_92852_((FormattedText)ImageFontConstants.EYE_OPEN)) / 2.0f;
        Objects.requireNonNull(mc.f_91062_);
        font.m_272077_(ImageFontConstants.EYE_OPEN, f, (float)(-9) / 2.0f, FastColor.ABGR32.m_266498_((int)opacity, (int)0xFFFFFF), false, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }
}

