/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.recording.RecordingData;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.GameModeAction;
import fr.loudo.narrativecraft.narrative.recording.actions.RidingAction;
import fr.loudo.narrativecraft.narrative.recording.actions.modsListeners.ModsListenerImpl;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;

public class Recording {
    private final AtomicInteger ids = new AtomicInteger();
    private final List<Entity> trackedEntities = new ArrayList<Entity>();
    private final List<RecordingData> recordingDataList = new ArrayList<RecordingData>();
    private final PlayerSession playerSession;
    private List<Subscene> subscenesPlaying = new ArrayList<Subscene>();
    private RecordingData entityRecorderData;
    private boolean isRecording;
    private int tick = 0;

    public Recording(LivingEntity entity, PlayerSession playerSession) {
        this.entityRecorderData = new RecordingData((Entity)entity, this);
        this.entityRecorderData.setSavingTrack(true);
        this.entityRecorderData.getActionsData().setEntityIdRecording(this.ids.incrementAndGet());
        this.isRecording = false;
        this.playerSession = playerSession;
    }

    public Recording(LivingEntity entity, PlayerSession playerSession, List<Subscene> subscenes) {
        this(entity, playerSession);
        this.subscenesPlaying = subscenes;
    }

    public boolean isSameEntity(Entity entity) {
        return this.entityRecorderData.getEntity().m_20148_().equals(entity.m_20148_());
    }

    public void start() {
        if (this.isRecording) {
            return;
        }
        this.tick = 0;
        this.ids.set(0);
        this.entityRecorderData = new RecordingData(this.entityRecorderData.getEntity(), this);
        this.entityRecorderData.setSavingTrack(true);
        this.entityRecorderData.getActionsData().setEntityIdRecording(this.ids.incrementAndGet());
        this.recordingDataList.clear();
        this.trackedEntities.clear();
        this.recordingDataList.add(this.entityRecorderData);
        this.isRecording = true;
        Entity entity = this.entityRecorderData.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            GameModeAction gameModeAction = new GameModeAction(0, player.f_8941_.m_9290_(), player.f_8941_.m_9290_());
            this.entityRecorderData.getActionsData().addAction(gameModeAction);
        }
        for (Subscene subscene : this.subscenesPlaying) {
            subscene.start(this.playerSession.getPlayer().m_9236_(), Environment.RECORDING, false);
            this.playerSession.getPlaybackManager().getPlaybacks().addAll(subscene.getPlaybacks());
        }
    }

    public void stop() {
        if (!this.isRecording) {
            return;
        }
        this.isRecording = false;
        for (Subscene subscene : this.subscenesPlaying) {
            subscene.stop(true);
            this.playerSession.getPlaybackManager().getPlaybacks().removeAll(subscene.getPlaybacks());
        }
        this.subscenesPlaying.clear();
        for (RecordingData recordingData : this.recordingDataList) {
            if (!(recordingData.getEntity() instanceof LivingEntity)) continue;
            recordingData.getActionsData().reset(recordingData.getEntity());
            for (ModsListenerImpl modsListener : recordingData.getActionDifferenceListener().getModsListenerList()) {
                modsListener.stop();
            }
        }
    }

    public void save(Animation animation) throws IOException {
        if (this.isRecording) {
            return;
        }
        List<ActionsData> actionsDataList = this.recordingDataList.stream().filter(RecordingData::isSavingTrack).map(RecordingData::getActionsData).toList();
        animation.setActionsData(actionsDataList);
        NarrativeCraftFile.updateAnimationFile(animation);
        animation.getScene().addAnimation(animation);
        this.recordingDataList.clear();
    }

    public void tick() {
        ActionsData actionsData;
        List<UUID> trackedUUIDs = this.trackedEntities.stream().map(Entity::m_20148_).toList();
        List nearbyEntities = this.entityRecorderData.getEntity().m_9236_().m_45933_(this.entityRecorderData.getEntity(), this.entityRecorderData.getEntity().m_20191_().m_82400_(30.0));
        for (Entity entity : nearbyEntities) {
            if (trackedUUIDs.contains(entity.m_20148_()) || entity instanceof Projectile || entity instanceof EyeOfEnder || entity instanceof ThrowableItemProjectile) continue;
            this.trackedEntities.add(entity);
            RecordingData recordingData = new RecordingData(entity, this);
            this.recordingDataList.add(recordingData);
            if (!(entity instanceof AbstractMinecart) && !(entity instanceof Boat) && !(entity instanceof AbstractHorse) && !(entity instanceof ItemEntity)) continue;
            this.trackEntity(entity, this.tick);
        }
        for (RecordingData recordingData : this.recordingDataList) {
            if (this.playerSession.getPlaybackManager().entityInPlayback(recordingData.getEntity())) {
                recordingData.setSavingTrack(false);
            }
            recordingData.getActionsData().addLocation();
            recordingData.getActionDifferenceListener().listenDifference();
        }
        if (this.tick == 0 && this.entityRecorderData.getEntity().m_20202_() != null && (actionsData = this.getActionDataFromEntity(this.entityRecorderData.getEntity().m_20202_())) != null) {
            RidingAction action = new RidingAction(0, actionsData.getEntityIdRecording());
            this.entityRecorderData.getActionsData().addAction(action);
        }
        ++this.tick;
    }

    public ActionsData getActionDataFromEntity(Entity entity) {
        for (RecordingData recordingData : this.recordingDataList) {
            if (!recordingData.isSameEntity(entity)) continue;
            recordingData.setSavingTrack(true);
            return recordingData.getActionsData();
        }
        return null;
    }

    public RecordingData getRecordingDataFromEntity(Entity entity) {
        for (RecordingData recordingData : this.recordingDataList) {
            if (!recordingData.isSameEntity(entity)) continue;
            return recordingData;
        }
        return null;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public Entity getEntity() {
        return this.entityRecorderData.getEntity();
    }

    public int getTick() {
        return this.tick;
    }

    public AtomicInteger getIds() {
        return this.ids;
    }

    public boolean trackEntity(Entity entity) {
        RecordingData recordingData = this.getRecordingDataFromEntity(entity);
        if (recordingData == null || recordingData.isSavingTrack()) {
            return false;
        }
        recordingData.setSavingTrack(true);
        recordingData.getActionsData().setSpawnTick(0);
        recordingData.getActionsData().setEntityIdRecording(this.ids.incrementAndGet());
        return true;
    }

    public void trackEntity(Entity entity, int tickSpawn) {
        if (!this.trackEntity(entity)) {
            return;
        }
        RecordingData recordingData = this.getRecordingDataFromEntity(entity);
        recordingData.getActionsData().setSpawnTick(tickSpawn);
    }

    public List<Subscene> getSubscenesPlaying() {
        return this.subscenesPlaying;
    }

    public void setSubscenesPlaying(List<Subscene> subscenesPlaying) {
        this.subscenesPlaying = subscenesPlaying;
    }
}

