/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.FakePlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;

public class ItemPickUpAction
extends Action {
    private final int entityRecordingId;

    public ItemPickUpAction(int tick, int entityRecordingId) {
        super(tick, ActionType.ITEM_PICKUP);
        this.entityRecordingId = entityRecordingId;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof FakePlayer) {
            FakePlayer fakePlayer = (FakePlayer)entity;
            ItemEntity item = (ItemEntity)playbackData.getPlayback().getEntityByRecordId(this.entityRecordingId);
            if (item == null) {
                return;
            }
            fakePlayer.m_7938_((Entity)item, item.m_32055_().m_41613_());
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        PlaybackData itemPlayback = playbackData.getPlayback().getPlaybackDataByRecordId(this.entityRecordingId);
        itemPlayback.killEntity();
        Location takeLoc = playbackData.getActionsData().getLocations().get(this.tick);
        if (takeLoc == null) {
            return;
        }
        itemPlayback.spawnEntity(takeLoc);
    }
}

