/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;

public class StorySave {
    private transient Chapter chapter;
    private transient Scene scene;
    private final String saveData;
    private final DialogData dialogData;
    private final List<String> tagsRunning;
    private final List<CharacterStoryData> characterStoryDataList = new ArrayList<CharacterStoryData>();
    private final List<String> areaTriggersEnteredName = new ArrayList<String>();

    public StorySave(PlayerSession playerSession) throws Exception {
        StoryHandler storyHandler = playerSession.getStoryHandler();
        playerSession.getAreaTriggersEntered().forEach(areaTrigger -> {
            if (!this.areaTriggersEnteredName.contains(areaTrigger.getName())) {
                this.areaTriggersEnteredName.add(areaTrigger.getName());
            }
        });
        this.chapter = playerSession.getChapter();
        this.scene = playerSession.getScene();
        this.saveData = storyHandler.getStory().getState().toJson();
        this.dialogData = storyHandler.getDialogData();
        List<InkAction> inkActions = playerSession.getInkActions().stream().filter(InkAction::isRunning).toList();
        this.tagsRunning = new ArrayList<String>(inkActions.stream().map(InkAction::getCommand).toList());
        this.removeForbiddenTagLoadSave(this.tagsRunning);
        for (CharacterRuntime characterRuntime : playerSession.getCharacterRuntimes()) {
            for (Playback playback : playerSession.getPlaybackManager().getPlaybacks()) {
                if (playback.getCharacter().getName().equalsIgnoreCase(characterRuntime.getCharacterStory().getName())) {
                    return;
                }
                if (characterRuntime.getEntity() != null) continue;
                return;
            }
            LivingEntity entity = characterRuntime.getEntity();
            CharacterStoryData characterStoryData = new CharacterStoryData(characterRuntime.getCharacterStory(), new Location(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146909_(), entity.m_146908_(), entity.m_20096_()), false, this.scene);
            characterStoryData.setPose(entity.m_20089_());
            characterStoryData.setItems(characterRuntime.getEntity());
            characterStoryData.setEntityByte((Byte)characterRuntime.getEntity().m_20088_().m_135370_(EntityAccessor.getDATA_SHARED_FLAGS_ID()));
            characterStoryData.setLivingEntityByte((Byte)characterRuntime.getEntity().m_20088_().m_135370_(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS()));
            this.characterStoryDataList.add(characterStoryData);
        }
    }

    private void removeForbiddenTagLoadSave(List<String> commands) {
        commands.remove("save");
        commands.remove("on enter");
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setChapter(Chapter chapter) {
        this.chapter = chapter;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public String getSaveData() {
        return this.saveData;
    }

    public DialogData getDialogData() {
        return this.dialogData;
    }

    public List<String> getTagsRunning() {
        return this.tagsRunning;
    }

    public List<CharacterStoryData> getCharacterStoryDataList() {
        return this.characterStoryDataList;
    }

    public List<String> getAreaTriggersEnteredName() {
        return this.areaTriggersEnteredName;
    }
}

