/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StoryValidation {
    public static final String TAG_REGEX = "#\\s*([^#]+)\\s*";

    public static List<ErrorLine> validate() throws Exception {
        ArrayList<ErrorLine> errorLines = new ArrayList<ErrorLine>();
        List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
        for (Chapter chapter : chapters) {
            try {
                errorLines.addAll(StoryValidation.validateChapter(chapter));
            }
            catch (IOException e) {
                throw new Exception(Translation.message("validation.chapter_file_no_exists", chapter.getIndex()).getString());
            }
            for (Scene scene : chapter.getSortedSceneList()) {
                try {
                    errorLines.addAll(StoryValidation.validateScene(scene));
                }
                catch (IOException e) {
                    throw new Exception(Translation.message("validation.scene_file_no_exists", scene.getName(), chapter.getIndex()).getString());
                }
            }
        }
        return errorLines;
    }

    private static List<ErrorLine> validateChapter(Chapter chapter) throws IOException {
        return StoryValidation.validate(NarrativeCraftFile.getScriptFile(chapter), chapter, chapter.getSortedSceneList().get(0));
    }

    private static List<ErrorLine> validateScene(Scene scene) throws IOException {
        return StoryValidation.validate(NarrativeCraftFile.getScriptFile(scene), null, scene);
    }

    private static List<ErrorLine> validate(File scriptFile, Chapter chapter, Scene scene) throws IOException {
        ArrayList<ErrorLine> errorLines = new ArrayList<ErrorLine>();
        Pattern tagPattern = Pattern.compile(TAG_REGEX);
        String[] lines = Files.readString(scriptFile.toPath()).split("\n");
        boolean firstMatcherFound = false;
        for (int i = 0; i < lines.length; ++i) {
            String rawLine = lines[i].trim();
            if (!rawLine.startsWith("#")) continue;
            Matcher matcher = tagPattern.matcher(rawLine);
            while (matcher.find()) {
                InkActionResult result;
                InkAction inkAction;
                String command = matcher.group(1).trim();
                if (!firstMatcherFound) {
                    firstMatcherFound = true;
                    if (i + 1 == 2 && !command.equals("on enter")) {
                        errorLines.add(new ErrorLine(i + 1, null, scene, Translation.message("validation.on_enter_required", new Object[0]).getString(), command, false));
                    }
                }
                if ((inkAction = InkActionRegistry.findByCommand(command)) == null || !(result = inkAction.validate(command, scene)).isError() && !result.isWarn()) continue;
                errorLines.add(new ErrorLine(i + 1, chapter, chapter == null ? scene : null, result.errorMessage(), command, result.isWarn()));
            }
        }
        return errorLines;
    }
}

