/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class BorderInkAction
extends InkAction {
    private float up;
    private float right;
    private float down;
    private float left;
    private float upInterpolated;
    private float rightInterpolated;
    private float downInterpolated;
    private float leftInterpolated;
    private int color;
    private double opacity;
    private Easing easing;
    private String fadeAction;

    public BorderInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (this.tick == this.totalTick && this.fadeAction.equals("out")) {
            this.isRunning = false;
        }
        if (this.tick < this.totalTick) {
            ++this.tick;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float partialTick) {
        if (!this.isRunning) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        int widthScreen = minecraft.m_91268_().m_85445_();
        int heightScreen = minecraft.m_91268_().m_85446_();
        int guiScale = (Integer)minecraft.f_91066_.m_231928_().m_231551_();
        if ((Integer)minecraft.f_91066_.m_231928_().m_231551_() == 0) {
            guiScale = 3;
        }
        float up = this.up;
        float right = this.right;
        float down = this.down;
        float left = this.left;
        if (this.fadeAction.equals("out") && this.tick == this.totalTick) {
            up = 0.0f;
            right = 0.0f;
            down = 0.0f;
            left = 0.0f;
        }
        if (this.tick < this.totalTick) {
            double t = Mth.m_14008_((double)(((float)this.tick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
            t = this.easing.interpolate(t);
            if (this.fadeAction.equals("in")) {
                up = (float)Mth.m_14139_((double)t, (double)0.0, (double)this.up);
                right = (float)Mth.m_14139_((double)t, (double)0.0, (double)this.right);
                down = (float)Mth.m_14139_((double)t, (double)0.0, (double)this.down);
                left = (float)Mth.m_14139_((double)t, (double)0.0, (double)this.left);
            } else if (this.fadeAction.equals("out")) {
                up = (float)Mth.m_14139_((double)t, (double)this.up, (double)0.0);
                right = (float)Mth.m_14139_((double)t, (double)this.right, (double)0.0);
                down = (float)Mth.m_14139_((double)t, (double)this.down, (double)0.0);
                left = (float)Mth.m_14139_((double)t, (double)this.left, (double)0.0);
            }
            this.upInterpolated = up;
            this.rightInterpolated = right;
            this.downInterpolated = down;
            this.leftInterpolated = left;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexConsumer = minecraft.m_91269_().m_110104_().m_6299_(RenderType.m_285907_());
        poseStack.m_85836_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, up / (float)guiScale, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen, up / (float)guiScale, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen, 0.0f, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen - right / (float)guiScale, 0.0f, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen - right / (float)guiScale, (float)heightScreen, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen, (float)heightScreen, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen, 0.0f, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)heightScreen - down / (float)guiScale, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)heightScreen, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen, (float)heightScreen, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)widthScreen, (float)heightScreen - down / (float)guiScale, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, (float)heightScreen, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, left / (float)guiScale, (float)heightScreen, 0.0f).m_193479_(this.color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, left / (float)guiScale, 0.0f, 0.0f).m_193479_(this.color).m_5752_();
        poseStack.m_85849_();
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        this.fadeAction = "";
        this.easing = Easing.SMOOTH;
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Up value missing"));
        }
        if (arguments.get(1).equals("clear")) {
            return InkActionResult.ok();
        }
        if (arguments.get(1).equals("out")) {
            this.fadeAction = "out";
            if (arguments.size() == 2) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade time value"));
            }
            try {
                this.totalTick = (int)(Double.parseDouble(arguments.get(2)) * 20.0);
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(2)));
            }
            this.easing = Easing.SMOOTH;
            if (arguments.size() > 3) {
                try {
                    this.easing = Easing.valueOf(arguments.get(3).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_easing_value", Arrays.toString((Object[])Easing.values())));
                }
            }
            return InkActionResult.ok();
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Right value missing"));
        }
        if (arguments.size() == 3) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Down value missing"));
        }
        if (arguments.size() == 4) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Left value missing"));
        }
        try {
            this.up = Integer.parseInt(arguments.get(1)) * 2;
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(1)));
        }
        try {
            this.right = Integer.parseInt(arguments.get(2)) * 2;
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(2)));
        }
        try {
            this.down = Integer.parseInt(arguments.get(3)) * 2;
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
        }
        try {
            this.left = Integer.parseInt(arguments.get(4)) * 2;
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
        }
        if (arguments.size() > 5) {
            try {
                this.color = Integer.parseInt(arguments.get(5), 16);
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.color", arguments.get(5)));
            }
        }
        this.opacity = 1.0;
        if (arguments.size() > 6) {
            try {
                this.opacity = Double.parseDouble(arguments.get(6));
                if (this.opacity > 1.0) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "The opacity value is greater than 1"));
                }
                if (this.opacity < 0.0) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "The opacity value is less than 0"));
                }
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(6)));
            }
        }
        this.color = FastColor.ABGR32.m_266498_((int)((int)(this.opacity * 255.0)), (int)this.color);
        if (arguments.size() < 7) {
            return InkActionResult.ok();
        }
        this.fadeAction = arguments.get(7);
        if (!this.fadeAction.equals("in")) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Action must be \"in\""));
        }
        if (arguments.size() == 8) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade time value"));
        }
        try {
            this.totalTick = (int)(Double.parseDouble(arguments.get(8)) * 20.0);
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(8)));
        }
        if (arguments.size() == 9) {
            return InkActionResult.ok();
        }
        try {
            this.easing = Easing.valueOf(arguments.get(9).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_easing_value", Arrays.toString((Object[])Easing.values())));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        if (this.fadeAction.equals("out")) {
            for (InkAction inkAction2 : playerSession.getClientSideInkActions()) {
                if (!(inkAction2 instanceof BorderInkAction)) continue;
                BorderInkAction borderInkAction = (BorderInkAction)inkAction2;
                borderInkAction.isRunning = false;
                this.up = borderInkAction.upInterpolated;
                this.right = borderInkAction.rightInterpolated;
                this.down = borderInkAction.downInterpolated;
                this.left = borderInkAction.leftInterpolated;
                this.opacity = borderInkAction.opacity;
                this.color = borderInkAction.color;
                this.easing = borderInkAction.easing;
            }
        }
        if (this.up == 0.0f && this.right == 0.0f && this.down == 0.0f && this.left == 0.0f) {
            playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof BorderInkAction);
            this.isRunning = false;
        }
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

