/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.inkAction.CameraAngleInkAction;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class GameplayInkAction
extends InkAction {
    public GameplayInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof GameplayInkAction);
        CharacterStory mainCharacter = NarrativeCraftMod.getInstance().getCharacterManager().getMainCharacter();
        if (mainCharacter == null) {
            return InkActionResult.error("A main character assigned is required for this tag to work!");
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return InkActionResult.ignored();
        }
        if (playerSession.getDialogRenderer() != null) {
            playerSession.getDialogRenderer().setRunDialogStopped(() -> {
                playerSession.setDialogRenderer(null);
                this.execute(playerSession);
                playerSession.getInkActions().add(this);
            });
            playerSession.getDialogRenderer().stop();
            return InkActionResult.ok();
        }
        if (storyHandler.characterInStory(mainCharacter)) {
            List<CharacterRuntime> characterRuntimes = storyHandler.getCharacterRuntimeFromCharacter(mainCharacter);
            if (characterRuntimes.isEmpty()) {
                return InkActionResult.error("Main character was found in the story, but his entity was not...");
            }
            Vec3 position = characterRuntimes.get(0).getEntity().m_20182_();
            LivingEntity entity = characterRuntimes.get(0).getEntity();
            playerSession.getPlayer().f_8906_.m_9774_(position.f_82479_, position.f_82480_, position.f_82481_, entity.m_146908_(), entity.m_146909_());
            storyHandler.killCharacter(mainCharacter);
        }
        if (playerSession.getController() != null) {
            playerSession.getController().stopSession(false);
        }
        playerSession.setCurrentCamera(null);
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof CameraAngleInkAction);
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

