/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MinecraftCommandInkAction
extends InkAction {
    private String command;

    public MinecraftCommandInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Command value"));
        }
        this.command = arguments.get(1);
        this.command = this.command.replace("\\{", "{");
        this.command = this.command.replace("\\}", "}");
        CommandSourceStack commandSourceStack = new CommandSourceStack(null, null, null, null, 4, null, null, NarrativeCraftMod.server, null);
        ParseResults parse = NarrativeCraftMod.server.m_129892_().m_82094_().parse(new StringReader(this.command), (Object)commandSourceStack);
        if (parse.getReader().canRead() && parse.getExceptions().size() == 1) {
            String commandError = ((CommandSyntaxException)((Object)parse.getExceptions().values().iterator().next())).getMessage();
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Command can't be executed: " + commandError));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        CommandSourceStack commandSourceStack = this.getCommandSourceStack(playerSession);
        this.command = this.command.replace("@p", playerSession.getPlayer().m_7755_().getString());
        try {
            playerSession.getPlayer().m_9236_().m_7654_().m_129892_().m_82094_().execute(this.command, (Object)commandSourceStack);
        }
        catch (CommandSyntaxException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Command can't be executed: " + e.getMessage()));
        }
        this.isRunning = false;
        return InkActionResult.ok();
    }

    private CommandSourceStack getCommandSourceStack(PlayerSession playerSession) {
        ServerPlayer player = playerSession.getPlayer();
        CommandSource commandSource = CommandSource.f_80164_;
        return new CommandSourceStack(commandSource, player.m_20182_(), player.m_20155_(), (ServerLevel)player.m_9236_(), 4, player.m_7755_().getString(), player.m_5446_(), player.m_9236_().m_7654_(), (Entity)player);
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

