/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public class WeatherInkAction
extends InkAction {
    private String weather;
    private boolean instantly;

    public WeatherInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "clear, rain or thunder"));
        }
        this.weather = arguments.get(1);
        if (!(this.weather.equals("clear") || this.weather.equals("rain") || this.weather.equals("thunder"))) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Only clear, rain or thunder"));
        }
        this.instantly = InkUtil.getOptionalArgument(this.command, "instant");
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        ServerLevel level = (ServerLevel)playerSession.getPlayer().m_9236_();
        ServerGamePacketListenerImpl connection = playerSession.getPlayer().f_8906_;
        boolean isSinglePlayer = level.m_7654_().m_129792_();
        switch (this.weather) {
            case "clear": {
                if (this.instantly || !isSinglePlayer) {
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132155_, 0.0f));
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, 0.0f));
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, 0.0f));
                    break;
                }
                level.m_8606_(999999, 0, false, false);
                break;
            }
            case "rain": {
                if (this.instantly || !isSinglePlayer) {
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132154_, 0.0f));
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, 1.0f));
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, 0.0f));
                    break;
                }
                level.m_8606_(0, 999999, true, false);
                break;
            }
            case "thunder": {
                if (this.instantly || !isSinglePlayer) {
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132154_, 0.0f));
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, 1.0f));
                    connection.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, 1.0f));
                    break;
                }
                level.m_8606_(0, 999999, true, true);
                break;
            }
            default: {
                return InkActionResult.error("Weather value is not correct.");
            }
        }
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof WeatherInkAction);
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

