/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction.sound;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.audio.VolumeAudio;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.inkAction.sound.SoundInkInstance;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class SoundInkAction
extends InkAction {
    private SoundManager soundManager;
    private SoundInstance simpleSoundInstance;
    private String identifier = "minecraft";
    private String name;
    private String action;
    private Type type;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private boolean isLooping;
    private double fadeTime;
    private int currentTick;
    private int totalTick;

    public SoundInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (!this.soundManager.m_120403_(this.simpleSoundInstance)) {
            this.isRunning = false;
        }
        if (!this.isRunning || this.totalTick == 0) {
            return;
        }
        ++this.tick;
        boolean bl = this.isRunning = this.tick <= this.totalTick || this.action.equals("start");
        if (!this.isRunning) {
            this.soundManager.m_120399_(this.simpleSoundInstance);
        }
    }

    @Override
    public void partialTick(float partialTick) {
        if (!this.isRunning || this.totalTick == 0) {
            return;
        }
        double t = Mth.m_14008_((double)(((float)this.tick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        float newVolume = 0.0f;
        if (this.action.equals("start")) {
            newVolume = (float)Mth.m_14139_((double)t, (double)0.0, (double)this.volume);
        } else if (this.action.equals("stop")) {
            newVolume = (float)Mth.m_14139_((double)t, (double)this.volume, (double)0.0);
        }
        ((VolumeAudio)this.soundManager).narrativecraft$setVolume(this.simpleSoundInstance, newVolume);
        if ((double)newVolume == 0.0 && this.action.equals("stop")) {
            this.soundManager.m_120399_(this.simpleSoundInstance);
        }
    }

    @Override
    public void stop() {
        if (this.soundManager == null || this.simpleSoundInstance == null) {
            return;
        }
        this.soundManager.m_120399_(this.simpleSoundInstance);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        ResourceLocation location;
        Minecraft minecraft = Minecraft.m_91087_();
        this.soundManager = minecraft.m_91106_();
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Start or stop"));
        }
        String typeName = arguments.get(0);
        this.type = Type.valueOf(typeName.toUpperCase());
        this.action = arguments.get(1);
        if (!this.action.equals("start") && !this.action.equals("stop")) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Only start or stop action"));
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", this.type.name().toLowerCase() + " name"));
        }
        this.name = arguments.get(2);
        if (this.action.equals("stop") && this.name.equals("all")) {
            return InkActionResult.ok();
        }
        if (this.name.contains(":")) {
            String[] splitName = this.name.split(":");
            this.identifier = splitName[0];
            this.name = splitName[1];
        }
        if (this.soundManager.m_120384_(location = new ResourceLocation(this.identifier, this.name)) == null) {
            return InkActionResult.warn((Component)Translation.message("ink_action.validation.sound", this.type.name().toLowerCase(), this.name));
        }
        if (this.action.equals("start") && arguments.size() > 3) {
            this.isLooping = InkUtil.getOptionalArgument(this.command, "loop");
            try {
                this.volume = Float.parseFloat(arguments.get(3));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
            }
            if (arguments.size() == 4) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "pitch"));
            }
            try {
                this.pitch = Float.parseFloat(arguments.get(4));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
            }
            if (arguments.size() == 5) {
                return InkActionResult.ok();
            }
            String fadeValue = arguments.get(5);
            if (!fadeValue.equals("fadein")) {
                return InkActionResult.ok();
            }
            if (arguments.size() == 6) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "fade in value"));
            }
            try {
                this.fadeTime = Double.parseDouble(arguments.get(6));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(6)));
            }
            this.simpleSoundInstance = this.getSimpleSoundInstance();
            this.soundManager.m_120367_(this.simpleSoundInstance);
            if (this.fadeTime > 0.0) {
                ((VolumeAudio)this.soundManager).narrativecraft$setVolume(this.simpleSoundInstance, 0.0f);
            }
        } else if (this.action.equals("stop") && arguments.size() > 3) {
            String fadeValue = arguments.get(3);
            if (!fadeValue.equals("fadeout")) {
                return InkActionResult.ok();
            }
            if (arguments.size() == 4) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "fade out value"));
            }
            try {
                this.fadeTime = Double.parseDouble(arguments.get(4));
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
            }
        }
        this.totalTick = (int)(this.fadeTime * 20.0);
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        if (this.action.equals("start")) {
            this.simpleSoundInstance = this.getSimpleSoundInstance();
            this.soundManager.m_120367_(this.simpleSoundInstance);
            if (this.fadeTime > 0.0) {
                ((VolumeAudio)this.soundManager).narrativecraft$setVolume(this.simpleSoundInstance, 0.0f);
            }
        } else if (this.action.equals("stop")) {
            for (InkAction inkAction : playerSession.getInkActions()) {
                boolean matchOne;
                if (!(inkAction instanceof SoundInkAction)) continue;
                SoundInkAction soundInkAction = (SoundInkAction)inkAction;
                boolean matchAll = this.name.equals("all") && (soundInkAction.type == this.type || this.type == Type.SOUND);
                boolean bl = matchOne = !this.name.equals("all") && soundInkAction.name.equals(this.name) && this.type == soundInkAction.type;
                if (matchAll || matchOne) {
                    soundInkAction.isRunning = false;
                }
                if (matchAll) {
                    this.isRunning = false;
                    soundInkAction.stop();
                    continue;
                }
                if (!matchOne) continue;
                if (this.fadeTime > 0.0) {
                    this.simpleSoundInstance = soundInkAction.simpleSoundInstance;
                    this.volume = soundInkAction.volume;
                    continue;
                }
                this.isRunning = false;
                soundInkAction.stop();
            }
        }
        return InkActionResult.ok();
    }

    private SoundInstance getSimpleSoundInstance() {
        if (this.simpleSoundInstance == null) {
            this.simpleSoundInstance = new SoundInkInstance(new ResourceLocation(this.identifier, this.name), SoundSource.MASTER, this.volume, this.pitch, SoundInstance.m_235150_(), this.isLooping, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        }
        return this.simpleSoundInstance;
    }

    @Override
    public boolean needScene() {
        return false;
    }

    public static enum Type {
        SFX,
        SONG,
        SOUND;

    }
}

