/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction.text;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.narrative.dialog.animation.AbstractDialogScrollText;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.Attribute;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.Position;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.TextInkAction;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class DialogScrollTextInkAction
extends AbstractDialogScrollText {
    private final TextInkAction textInkAction;
    private boolean isBlock;
    private int endAt;

    public DialogScrollTextInkAction(Minecraft minecraft, TextInkAction textInkAction) {
        super(minecraft);
        this.textInkAction = textInkAction;
    }

    @Override
    protected List<String> splitTextIntoLines(String text) {
        Attribute attribute = this.textInkAction.getAttribute();
        return Util.splitText(text, this.minecraft.f_91062_, attribute.getWidth());
    }

    @Override
    protected float getInitialX() {
        return 0.0f;
    }

    @Override
    protected float getInitialY() {
        return 0.0f;
    }

    @Override
    protected boolean canScroll() {
        return true;
    }

    public int getEndAt() {
        return this.endAt;
    }

    public void setEndAt(int endAt) {
        this.endAt = endAt;
    }

    public void render(GuiGraphics guiGraphics, float partialTick, double opacity) {
        Attribute attribute = this.textInkAction.getAttribute();
        if (!attribute.isRender()) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        Font font = attribute.getFont();
        Position position = attribute.getPosition();
        MutableComponent longerText = Component.m_237113_((String)this.getLongerTextLine()).m_130938_(style -> {
            if (attribute.getCustomFont() == null) {
                return style;
            }
            return style.m_131150_(attribute.getCustomFont());
        });
        int textWidth = font.m_92724_(longerText.m_7532_());
        Objects.requireNonNull(font);
        int textHeight = 9;
        float centerX = (float)guiGraphics.m_280182_() / 2.0f;
        float centerY = (float)guiGraphics.m_280206_() / 2.0f;
        float totalHeight = textHeight * this.lines.size();
        float anchorX = 0.0f;
        float anchorY = 0.0f;
        float textOffsetX = 0.0f;
        float textOffsetY = 0.0f;
        switch (position) {
            case TOP: {
                anchorX = centerX;
                anchorY = 0.0f;
                textOffsetX = (float)(-textWidth) / 2.0f;
                textOffsetY = 0.0f;
                break;
            }
            case TOP_LEFT: {
                anchorX = 0.0f;
                anchorY = 0.0f;
                textOffsetX = 0.0f;
                textOffsetY = 0.0f;
                break;
            }
            case TOP_RIGHT: {
                anchorX = guiGraphics.m_280182_();
                anchorY = 0.0f;
                textOffsetX = -textWidth;
                textOffsetY = 0.0f;
                break;
            }
            case MIDDLE: {
                anchorX = centerX;
                anchorY = centerY;
                textOffsetX = (float)(-textWidth) / 2.0f;
                textOffsetY = -totalHeight / 2.0f;
                break;
            }
            case MIDDLE_LEFT: {
                anchorX = 0.0f;
                anchorY = centerY;
                textOffsetX = 0.0f;
                textOffsetY = -totalHeight / 2.0f;
                break;
            }
            case MIDDLE_RIGHT: {
                anchorX = guiGraphics.m_280182_();
                anchorY = centerY;
                textOffsetX = -textWidth;
                textOffsetY = -totalHeight / 2.0f;
                break;
            }
            case BOTTOM: {
                anchorX = centerX;
                anchorY = guiGraphics.m_280206_();
                textOffsetX = (float)(-textWidth) / 2.0f;
                textOffsetY = -totalHeight;
                break;
            }
            case BOTTOM_LEFT: {
                anchorX = 0.0f;
                anchorY = guiGraphics.m_280206_();
                textOffsetX = 0.0f;
                textOffsetY = -totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                anchorX = guiGraphics.m_280182_();
                anchorY = guiGraphics.m_280206_();
                textOffsetX = -textWidth;
                textOffsetY = -totalHeight;
            }
        }
        float[] spacing = attribute.getSpacing();
        if (spacing == null) {
            spacing = new float[]{0.0f, 0.0f};
        }
        poseStack.m_85836_();
        poseStack.m_252880_(anchorX + spacing[0], anchorY + spacing[1], 0.0f);
        poseStack.m_85841_(attribute.getScale(), attribute.getScale(), attribute.getScale());
        poseStack.m_252880_(textOffsetX, textOffsetY, 0.0f);
        Map<Integer, Vector2f> offsets = this.getTextEffectOffsets(partialTick);
        for (int i = 0; i < this.lettersRenderer.size(); ++i) {
            AbstractDialogScrollText.LetterLocation letter = (AbstractDialogScrollText.LetterLocation)this.lettersRenderer.get(i);
            if (!letter.render()) continue;
            float x = letter.x();
            float y = letter.y();
            if (offsets.containsKey(i)) {
                x += offsets.get((Object)Integer.valueOf((int)i)).x;
                y += offsets.get((Object)Integer.valueOf((int)i)).y;
            }
            MultiBufferSource.BufferSource bufferSource = this.minecraft.m_91269_().m_110104_();
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            font.m_271703_(String.valueOf(letter.letter()), x, y, FastColor.ABGR32.m_266498_((int)((int)(opacity * 255.0)), (int)this.textInkAction.getAttribute().getColor()), attribute.isDropShadow(), matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        }
        poseStack.m_85849_();
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public void setBlock(boolean block) {
        this.isBlock = block;
    }
}

