/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction.text;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.Attribute;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.DialogScrollTextInkAction;
import fr.loudo.narrativecraft.narrative.story.inkAction.text.Position;
import fr.loudo.narrativecraft.util.FadeState;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TextInkAction
extends InkAction {
    private String action;
    private int editTextCount;
    private Attribute attribute;
    private final DialogScrollTextInkAction dialogScrollTextInkAction = new DialogScrollTextInkAction(Minecraft.m_91087_(), this);
    private int waitUntilEndTick;
    private static final double TICKS_PER_SECOND = 20.0;
    private static final Map<String, BiConsumer<TextInkAction, TextInkAction>> UPDATE_ACTIONS = TextInkAction.createUpdateActionsMap();

    public TextInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (this.tick < this.totalTick) {
            ++this.tick;
        }
        if (this.tick == this.totalTick && this.attribute.getFadeState() != null) {
            this.handleFadeStateTransition();
        }
        this.dialogScrollTextInkAction.tick();
        if (!this.attribute.isNoTyping() && this.dialogScrollTextInkAction.isFinished()) {
            this.handleTypingCompletion();
        }
    }

    private void handleFadeStateTransition() {
        FadeState fadeState = this.attribute.getFadeState();
        switch (fadeState) {
            case FADE_IN: {
                if (this.attribute.getStay() == -1.0) break;
                this.attribute.setFadeState(FadeState.STAY);
                this.totalTick = (int)(this.attribute.getStay() * 20.0);
                this.tick = 0;
                break;
            }
            case STAY: {
                this.totalTick = (int)(this.attribute.getOut() * 20.0);
                this.attribute.setFadeState(FadeState.FADE_OUT);
                this.tick = 0;
                break;
            }
            case FADE_OUT: {
                this.isRunning = false;
                if (!this.dialogScrollTextInkAction.isBlock()) break;
                this.blockEndTask.run();
            }
        }
    }

    private void handleTypingCompletion() {
        ++this.waitUntilEndTick;
        if (this.waitUntilEndTick >= this.dialogScrollTextInkAction.getEndAt()) {
            this.waitUntilEndTick = 0;
            FadeState fadeState = this.attribute.getFadeState();
            if (fadeState != FadeState.FADE_OUT) {
                if (fadeState == FadeState.STAY && this.tick >= this.totalTick) {
                    this.attribute.setFadeState(FadeState.FADE_OUT);
                } else {
                    this.isRunning = false;
                    this.blockEndTask.run();
                }
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float partialTick) {
        if (!this.attribute.isRender()) {
            return;
        }
        this.dialogScrollTextInkAction.render(guiGraphics, partialTick, this.applyFade(partialTick));
    }

    private double applyFade(float partialTick) {
        double originalOpacity = this.attribute.getOpacity();
        FadeState fadeState = this.attribute.getFadeState();
        if (fadeState == FadeState.STAY || fadeState == null) {
            return originalOpacity;
        }
        double t = Mth.m_14008_((double)(((float)this.tick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        return switch (fadeState) {
            case FadeState.FADE_IN -> Mth.m_14139_((double)t, (double)0.1, (double)originalOpacity);
            case FadeState.FADE_OUT -> Mth.m_14139_((double)t, (double)originalOpacity, (double)0.1);
            default -> originalOpacity;
        };
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Text id"));
        }
        String id = arguments.get(1).toLowerCase();
        this.attribute = new Attribute(id, "");
        if (arguments.size() == 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Attribute (create, font...)"));
        }
        switch (this.action = arguments.get(2)) {
            case "create": {
                if (InkUtil.getOptionalArgument(this.command, "no-drop-shadow")) {
                    this.attribute.setDropShadow(false);
                }
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Text"));
                }
                this.attribute.setText(arguments.get(3));
                this.dialogScrollTextInkAction.setMuteSound(true);
                Minecraft.m_91087_().execute(() -> {
                    this.dialogScrollTextInkAction.setText((String)arguments.get(3));
                    this.dialogScrollTextInkAction.forceFinish();
                });
                this.attribute.setRender(true);
                this.attribute.setNoTyping(true);
                if (arguments.size() == 4) {
                    return InkActionResult.ok();
                }
                try {
                    this.attribute.setColor(Integer.parseInt(arguments.get(4), 16));
                    break;
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.color", arguments.get(4)));
                }
            }
            case "remove": {
                return InkActionResult.ok();
            }
            case "edit": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Text"));
                }
                this.attribute.setText(arguments.get(3));
                Minecraft.m_91087_().execute(() -> this.dialogScrollTextInkAction.setText((String)arguments.get(3)));
                break;
            }
            case "position": 
            case "pos": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Position value"));
                }
                try {
                    this.attribute.setPosition(Position.valueOf(arguments.get(3).toUpperCase()));
                    break;
                }
                catch (IllegalArgumentException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Not a valid position"));
                }
            }
            case "color": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Color value"));
                }
                try {
                    this.attribute.setColor(Integer.parseInt(arguments.get(3), 16));
                    break;
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.color", arguments.get(3)));
                }
            }
            case "spacing": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "X spacing value"));
                }
                float[] spacing = new float[2];
                try {
                    spacing[0] = Float.parseFloat(arguments.get(3));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                }
                if (arguments.size() == 4) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Y spacing value"));
                }
                try {
                    spacing[1] = Float.parseFloat(arguments.get(4));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
                }
                this.attribute.setSpacing(spacing);
                break;
            }
            case "width": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Width value"));
                }
                try {
                    this.attribute.setWidth(Integer.parseInt(arguments.get(3)));
                    break;
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                }
            }
            case "fade": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade in value"));
                }
                try {
                    this.attribute.setIn(Double.parseDouble(arguments.get(3)));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                }
                if (arguments.size() == 4) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Stay value"));
                }
                try {
                    this.attribute.setStay(Double.parseDouble(arguments.get(4)));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
                }
                if (arguments.size() == 5) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade out value"));
                }
                try {
                    this.attribute.setOut(Double.parseDouble(arguments.get(5)));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(5)));
                }
                this.totalTick = (int)(this.attribute.getIn() * 20.0);
                this.attribute.setFadeState(FadeState.FADE_IN);
                break;
            }
            case "fadein": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade in value"));
                }
                try {
                    this.attribute.setIn(Double.parseDouble(arguments.get(3)));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                }
                this.attribute.setStay(-1.0);
                this.totalTick = (int)(this.attribute.getIn() * 20.0);
                this.attribute.setFadeState(FadeState.FADE_IN);
                break;
            }
            case "fadeout": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade out value"));
                }
                try {
                    this.attribute.setOut(Double.parseDouble(arguments.get(3)));
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                }
                this.totalTick = (int)(this.attribute.getOut() * 20.0);
                this.attribute.setFadeState(FadeState.FADE_OUT);
                break;
            }
            case "font": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Font value"));
                }
                this.attribute.setCustomFont(new ResourceLocation(arguments.get(3)));
                break;
            }
            case "sound": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Sound value"));
                }
                this.attribute.setCustomLetterSound(new ResourceLocation(arguments.get(3)));
                break;
            }
            case "type": {
                this.dialogScrollTextInkAction.setBlock(InkUtil.getOptionalArgument(this.command, "block"));
                if (arguments.size() > 3) {
                    try {
                        this.dialogScrollTextInkAction.setEndAt((int)(Double.parseDouble(arguments.get(3)) * 20.0));
                    }
                    catch (NumberFormatException e) {
                        return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                    }
                }
                if (arguments.size() <= 4) break;
                try {
                    this.dialogScrollTextInkAction.setTextSpeed((float)((double)Float.parseFloat(arguments.get(4)) * 20.0));
                    break;
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(4)));
                }
            }
            case "scale": {
                if (arguments.size() == 3) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Scale value"));
                }
                try {
                    this.attribute.setScale(Float.parseFloat(arguments.get(3)));
                    break;
                }
                catch (NumberFormatException e) {
                    return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
                }
            }
            default: {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Not a valid attribute"));
            }
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        TextInkAction textInkAction = TextInkAction.getTextInkFromId(this.attribute.getId(), playerSession.getInkActions());
        if (textInkAction == null && this.action.equals("remove")) {
            return InkActionResult.ignored();
        }
        if (textInkAction == null && !this.action.equals("create")) {
            return InkActionResult.error(String.format("Text id '%s' not found!", this.attribute.getId()));
        }
        if (textInkAction != null && this.action.equals("create")) {
            return InkActionResult.error(String.format("Text id '%s' is already set!", this.attribute.getId()));
        }
        if (!this.action.equals("create")) {
            BiConsumer<TextInkAction, TextInkAction> updater = UPDATE_ACTIONS.get(this.action.toLowerCase());
            if (updater != null) {
                updater.accept(textInkAction, this);
            }
            this.isRunning = false;
            this.dialogScrollTextInkAction.setMuteSound(true);
            if (textInkAction.dialogScrollTextInkAction.isBlock() && this.action.equals("edit")) {
                return InkActionResult.block();
            }
        }
        return this.dialogScrollTextInkAction.isBlock() ? InkActionResult.block() : InkActionResult.ok();
    }

    private static Map<String, BiConsumer<TextInkAction, TextInkAction>> createUpdateActionsMap() {
        HashMap<String, BiConsumer<TextInkAction, TextInkAction>> map = new HashMap<String, BiConsumer<TextInkAction, TextInkAction>>();
        map.put("position", (target, source) -> target.attribute.setPosition(source.attribute.getPosition()));
        map.put("pos", (target, source) -> target.attribute.setPosition(source.attribute.getPosition()));
        map.put("edit", (target, source) -> {
            target.isRunning = true;
            target.attribute.setText(source.attribute.getText());
            Minecraft.m_91087_().execute(() -> {
                target.dialogScrollTextInkAction.setText(source.attribute.getText());
                target.dialogScrollTextInkAction.reset();
                if (target.attribute.isNoTyping()) {
                    target.dialogScrollTextInkAction.forceFinish();
                }
            });
            ++target.editTextCount;
        });
        map.put("remove", (target, source) -> {
            target.isRunning = false;
        });
        map.put("spacing", (target, source) -> target.attribute.setSpacing(source.attribute.getSpacing()));
        map.put("width", (target, source) -> {
            target.attribute.setWidth(source.attribute.getWidth());
            Minecraft.m_91087_().execute(() -> target.dialogScrollTextInkAction.setText(source.attribute.getText()));
        });
        map.put("text", (target, source) -> {
            target.attribute.setText(source.attribute.getText());
            Minecraft.m_91087_().execute(() -> target.dialogScrollTextInkAction.setText(source.attribute.getText()));
        });
        map.put("font", (target, source) -> target.attribute.setCustomFont(source.attribute.getCustomFont()));
        map.put("sound", (target, source) -> {
            target.attribute.setCustomLetterSound(source.attribute.getCustomLetterSound());
            target.dialogScrollTextInkAction.setLetterSound(source.attribute.getCustomLetterSound());
        });
        map.put("color", (target, source) -> target.attribute.setColor(source.attribute.getColor()));
        map.put("opacity", (target, source) -> target.attribute.setOpacity(source.attribute.getOpacity()));
        map.put("fade", (target, source) -> {
            target.attribute.setFadeState(source.attribute.getFadeState());
            target.attribute.setIn(source.attribute.getIn());
            target.attribute.setStay(source.attribute.getStay());
            target.attribute.setOut(source.attribute.getOut());
            FadeState fadeState = source.attribute.getFadeState();
            target.totalTick = switch (fadeState) {
                default -> throw new IncompatibleClassChangeError();
                case FadeState.FADE_IN -> (int)(source.attribute.getIn() * 20.0);
                case FadeState.STAY -> (int)(source.attribute.getStay() * 20.0);
                case FadeState.FADE_OUT -> (int)(source.attribute.getOut() * 20.0);
            };
        });
        map.put("fadein", (target, source) -> {
            target.attribute.setFadeState(FadeState.FADE_IN);
            target.attribute.setIn(source.attribute.getIn());
            target.attribute.setStay(-1.0);
            target.totalTick = (int)(source.attribute.getIn() * 20.0);
        });
        map.put("fadeout", (target, source) -> {
            target.attribute.setFadeState(FadeState.FADE_OUT);
            target.attribute.setOut(source.attribute.getOut());
            target.tick = 0;
            target.totalTick = (int)(source.attribute.getOut() * 20.0);
        });
        map.put("type", TextInkAction::lambda$createUpdateActionsMap$19);
        map.put("scale", (target, source) -> target.attribute.setScale(source.attribute.getScale()));
        return map;
    }

    @Override
    public boolean needScene() {
        return false;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public static TextInkAction getTextInkFromId(String id, List<InkAction> inkActions) {
        for (InkAction inkAction : inkActions) {
            if (!(inkAction instanceof TextInkAction)) continue;
            TextInkAction textInkAction = (TextInkAction)inkAction;
            if (!textInkAction.attribute.getId().equalsIgnoreCase(id)) continue;
            return textInkAction;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$createUpdateActionsMap$19(TextInkAction target, TextInkAction source) {
        target.dialogScrollTextInkAction.setTextSpeed(source.dialogScrollTextInkAction.getTextSpeed());
        target.dialogScrollTextInkAction.setBlock(source.dialogScrollTextInkAction.isBlock());
        target.setBlockEndTask(target.blockEndTask);
        target.dialogScrollTextInkAction.setEndAt(source.dialogScrollTextInkAction.getEndAt());
        target.attribute.setNoTyping(false);
        target.dialogScrollTextInkAction.setMuteSound(false);
        target.isRunning = true;
        if (!target.dialogScrollTextInkAction.isFinished()) ** GOTO lbl13
        if (target.editTextCount == 0) {
lbl13:
            // 2 sources

            Minecraft.m_91087_().execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, reset(), ()V)((DialogScrollTextInkAction)target.dialogScrollTextInkAction));
        } else {
            target.waitUntilEndTick = source.dialogScrollTextInkAction.getEndAt();
        }
        ++target.editTextCount;
    }
}

