/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.text;

import fr.loudo.narrativecraft.narrative.dialog.DialogAnimationType;
import fr.loudo.narrativecraft.narrative.dialog.DialogLetterEffect;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Vector2f;

public class TextEffectAnimation {
    private final List<DialogLetterEffect> dialogLetterEffectList;
    private final Map<Integer, Vector2f> letterOffsets = new HashMap<Integer, Vector2f>();
    private final Map<Integer, Vector2f> oldLetterOffsets = new HashMap<Integer, Vector2f>();
    private int tickCounter;

    public TextEffectAnimation(ParsedDialog parsedDialog) {
        this.dialogLetterEffectList = TextEffect.apply(parsedDialog.effects());
    }

    public void tick() {
        ++this.tickCounter;
        this.oldLetterOffsets.clear();
        this.oldLetterOffsets.putAll(this.letterOffsets);
        for (DialogLetterEffect dialogLetterEffect2 : this.dialogLetterEffectList.stream().filter(dialogLetterEffect -> dialogLetterEffect.getAnimation() != DialogAnimationType.WAIT).toList()) {
            dialogLetterEffect2.tick();
            if (dialogLetterEffect2.getAnimation() == DialogAnimationType.SHAKE) {
                for (int j = dialogLetterEffect2.getStartIndex(); j < dialogLetterEffect2.getEndIndex(); ++j) {
                    RandomSource randomSource = RandomSource.m_216327_();
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    if (dialogLetterEffect2.canApplyEffect()) {
                        offsetX = Mth.m_216283_((RandomSource)randomSource, (float)(-dialogLetterEffect2.getForce()), (float)dialogLetterEffect2.getForce());
                        offsetY = Mth.m_216283_((RandomSource)randomSource, (float)(-dialogLetterEffect2.getForce()), (float)dialogLetterEffect2.getForce());
                    } else if (this.letterOffsets.containsKey(j)) {
                        offsetX = this.letterOffsets.get((Object)Integer.valueOf((int)j)).x;
                        offsetY = this.letterOffsets.get((Object)Integer.valueOf((int)j)).y;
                    }
                    this.letterOffsets.put(j, new Vector2f(offsetX, offsetY));
                    this.oldLetterOffsets.put(j, new Vector2f(offsetX, offsetY));
                }
                continue;
            }
            if (dialogLetterEffect2.getAnimation() != DialogAnimationType.WAVE) continue;
            float waveSpacing = 0.2f;
            double waveSpeed = (double)this.tickCounter / (double)dialogLetterEffect2.getTotalTick();
            for (int j = dialogLetterEffect2.getStartIndex(); j < dialogLetterEffect2.getEndIndex(); ++j) {
                float offsetY = (float)(Math.sin(waveSpeed + (double)((float)j * waveSpacing)) * (double)dialogLetterEffect2.getForce());
                this.letterOffsets.put(j, new Vector2f(0.0f, offsetY));
            }
        }
    }

    public boolean canTick(int currentCharIndex) {
        for (DialogLetterEffect dialogLetterEffect2 : this.dialogLetterEffectList.stream().filter(dialogLetterEffect -> dialogLetterEffect.getAnimation() == DialogAnimationType.WAIT).toList()) {
            if (currentCharIndex < dialogLetterEffect2.getStartIndex() - 1) continue;
            dialogLetterEffect2.tick();
            return dialogLetterEffect2.getCooldownTick() == 0;
        }
        return true;
    }

    public Map<Integer, Vector2f> getOffsets(float partialTick) {
        HashMap<Integer, Vector2f> interpolated = new HashMap<Integer, Vector2f>();
        for (int j : this.letterOffsets.keySet()) {
            Vector2f oldOffset = this.oldLetterOffsets.getOrDefault(j, new Vector2f(0.0f, 0.0f));
            Vector2f newOffset = this.letterOffsets.get(j);
            float x = Mth.m_14179_((float)partialTick, (float)oldOffset.x, (float)newOffset.x);
            float y = Mth.m_14179_((float)partialTick, (float)oldOffset.y, (float)newOffset.y);
            interpolated.put(j, new Vector2f(x, y));
        }
        return interpolated;
    }
}

