/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class CharacterChangePoseScreen
extends Screen {
    private final Screen lastScreen;
    private final LivingEntity livingEntity;
    private final CharacterStoryData characterStoryData;

    public CharacterChangePoseScreen(Screen lastScreen, CharacterStoryData characterStoryData) {
        super((Component)Component.m_237113_((String)"Change pose camera angle screen"));
        this.livingEntity = characterStoryData.getCharacterRuntime().getEntity();
        this.characterStoryData = characterStoryData;
        this.lastScreen = lastScreen;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    protected void m_7856_() {
        List<Pose> poseList = List.of(Pose.STANDING, Pose.CROUCHING, Pose.SLEEPING, Pose.FALL_FLYING);
        int gap = 3;
        int startY = this.f_96544_ / 2 - gap - 5 * poseList.size() - 20;
        int startX = this.f_96543_ - 80 - 10;
        for (Pose pose : poseList) {
            Button poseButton = Button.m_253074_((Component)Component.m_237113_((String)pose.name()), button -> {
                this.livingEntity.m_20124_(pose);
                this.characterStoryData.setPose(pose);
                SynchedEntityData entityData = this.livingEntity.m_20088_();
                byte currentMask = (Byte)entityData.m_135370_(EntityAccessor.getDATA_SHARED_FLAGS_ID());
                byte currentLivingEntityByte = (Byte)entityData.m_135370_(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS());
                if (pose == Pose.CROUCHING) {
                    entityData.m_135381_(EntityAccessor.getDATA_SHARED_FLAGS_ID(), (Object)((byte)(currentMask | 2)));
                    this.characterStoryData.setEntityByte((byte)(currentMask | 2));
                } else {
                    entityData.m_135381_(EntityAccessor.getDATA_SHARED_FLAGS_ID(), (Object)((byte)(currentMask & 0xFFFFFFFD)));
                    this.characterStoryData.setEntityByte((byte)(currentMask & 0xFFFFFFFD));
                }
            }).m_252780_(80).m_252794_(startX, startY).m_253136_();
            startY += poseButton.m_93694_() + gap;
            this.m_142416_((GuiEventListener)poseButton);
        }
        Button closeBtn = Button.m_253074_((Component)Translation.message("global.close", new Object[0]), button -> this.m_7379_()).m_252780_(80).m_252794_(startX, startY).m_253136_();
        this.m_142416_((GuiEventListener)closeBtn);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }
}

