/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;

public class CharacterEntityTypeScreen
extends OptionsSubScreen {
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private EntityTypeList entityTypeList;
    private final List<EntityType<?>> entityTypes = NarrativeCraftMod.getInstance().getCharacterManager().getAvailableEntityTypes();
    private final CharacterStory characterStory;
    private final Scene scene;

    public CharacterEntityTypeScreen(Screen lastScreen, CharacterStory characterStory, Scene scene) {
        super(lastScreen, Minecraft.m_91087_().f_91066_, (Component)Translation.message("screen.character.change_entity_type", new Object[0]));
        this.characterStory = characterStory;
        this.scene = scene;
    }

    protected void m_7856_() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_267719_();
        super.m_7856_();
    }

    protected void addTitle() {
        this.layout.m_269471_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_));
    }

    protected void addContents() {
        this.entityTypeList = new EntityTypeList(this.f_96541_);
        this.m_142416_((GuiEventListener)this.entityTypeList);
    }

    private void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.m_7379_();
            this.f_96541_.m_91152_(this.f_96281_);
        }).m_253136_());
    }

    protected void m_267719_() {
        this.layout.m_264036_();
        this.entityTypeList.m_93437_(this.f_96543_, this.f_96544_, this.layout.m_269355_(), this.f_96544_ - this.layout.m_269040_());
    }

    public void m_7379_() {
        EntityTypeList.Entry entry = (EntityTypeList.Entry)this.entityTypeList.m_93511_();
        if (entry == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        EntityType<?> entityType = entry.entityType;
        this.f_96541_.m_91152_(this.f_96281_);
        this.characterStory.updateEntityType(entityType, this.scene);
    }

    class EntityTypeList
    extends ObjectSelectionList<Entry> {
        public EntityTypeList(Minecraft minecraft) {
            super(minecraft, CharacterEntityTypeScreen.this.f_96543_, CharacterEntityTypeScreen.this.f_96544_, 32, CharacterEntityTypeScreen.this.f_96544_ - 35, 18);
            int selectedEntityTypeId = CharacterEntityTypeScreen.this.characterStory.getEntityTypeId();
            CharacterEntityTypeScreen.this.entityTypes.forEach(entityType -> {
                Entry entry = new Entry((EntityType<?>)entityType);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                if (selectedEntityTypeId == BuiltInRegistries.f_256780_.m_7447_(entityType)) {
                    this.m_6987_((AbstractSelectionList.Entry)entry);
                }
            });
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            }
        }

        public int m_5759_() {
            return super.m_5759_() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final EntityType<?> entityType;

            public Entry(EntityType<?> entityType) {
                this.entityType = entityType;
            }

            public void m_6311_(GuiGraphics p_345300_, int p_345469_, int p_345328_, int p_345700_, int p_345311_, int p_345185_, int p_344805_, int p_345963_, boolean p_345912_, float p_346091_) {
                p_345300_.m_280137_(CharacterEntityTypeScreen.this.f_96547_, this.entityType.m_20676_().getString().toUpperCase(), EntityTypeList.this.f_93388_ / 2, p_345328_ + p_345185_ / 2 - 4, -1);
            }

            public boolean m_7933_(int p_346403_, int p_345881_, int p_345858_) {
                if (CommonInputs.m_278691_((int)p_346403_)) {
                    this.select();
                    CharacterEntityTypeScreen.this.m_7379_();
                    return true;
                }
                return super.m_7933_(p_346403_, p_345881_, p_345858_);
            }

            public boolean m_6375_(double p_344965_, double p_345385_, int p_345080_) {
                this.select();
                return super.m_6375_(p_344965_, p_345385_, p_345080_);
            }

            private void select() {
                EntityTypeList.this.m_6987_((AbstractSelectionList.Entry)this);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)CharacterEntityTypeScreen.this.characterStory.getName());
            }
        }
    }
}

