/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.screens.characters.CharacterChangePoseScreen;
import fr.loudo.narrativecraft.screens.components.ButtonListScreen;
import fr.loudo.narrativecraft.screens.components.ChangeSkinLinkScreen;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class CharacterOptionsScreen
extends ButtonListScreen {
    protected final AbstractController controller;
    protected final CharacterRuntime characterRuntime;
    protected final CharacterStoryData characterStoryData;

    public CharacterOptionsScreen(Screen lastScreen, AbstractController controller, CharacterRuntime characterRuntime) {
        super(lastScreen, (Component)Component.m_237113_((String)"Character options screen"));
        this.controller = controller;
        this.characterRuntime = characterRuntime;
        this.characterStoryData = controller.getCharacterStoryDataFromEntity((Entity)characterRuntime.getEntity());
    }

    @Override
    protected void addContents() {
        if (this.characterRuntime.getCharacterStory() == null) {
            return;
        }
        if (this.characterStoryData != null) {
            Button changeCharacterPoseButton = Button.m_253074_((Component)Translation.message("character.change_pose", new Object[0]), button -> {
                CharacterChangePoseScreen screen = new CharacterChangePoseScreen(this, this.characterStoryData);
                this.f_96541_.m_91152_((Screen)screen);
            }).m_253136_();
            this.objectListScreen.addButton((AbstractWidget)changeCharacterPoseButton);
        }
        if (this.characterRuntime.getCharacterStory().getCharacterType() == CharacterType.MAIN) {
            Button changeCharacterSkinButton = Button.m_253074_((Component)Translation.message("character.change_skin", new Object[0]), button -> {
                ChangeSkinLinkScreen screen = new ChangeSkinLinkScreen(this, this.characterRuntime, this.characterRuntime::setSkinName);
                this.f_96541_.m_91152_((Screen)screen);
            }).m_253136_();
            this.objectListScreen.addButton((AbstractWidget)changeCharacterSkinButton);
        }
        if (this.characterStoryData != null) {
            Button removeCharacterButton = Button.m_253074_((Component)Translation.message("global.remove", new Object[0]), button -> {
                ConfirmScreen confirm = new ConfirmScreen(b -> {
                    if (b) {
                        NarrativeCraftMod.server.execute(() -> {
                            this.characterStoryData.kill();
                            this.controller.removeCharacterStoryData(this.characterStoryData);
                        });
                    }
                    this.f_96541_.m_91152_(null);
                }, (Component)Component.m_237113_((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
                this.f_96541_.m_91152_((Screen)confirm);
            }).m_253136_();
            this.objectListScreen.addButton((AbstractWidget)removeCharacterButton);
        }
        if (this.objectListScreen.m_6702_().isEmpty()) {
            this.f_96541_.m_91152_(null);
        }
    }
}

