/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.util.Translation;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ChangeSkinLinkScreen
extends Screen {
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen lastScreen;
    private SkinList skinList;
    private final CharacterRuntime characterRuntime;
    private final Consumer<String> stringCallback;

    public ChangeSkinLinkScreen(Screen lastScreen, CharacterRuntime characterRuntime, Consumer<String> stringCallback) {
        super((Component)Translation.message("screen.change_skin_link.title", characterRuntime.getCharacterStory().getName()));
        this.lastScreen = lastScreen;
        this.characterRuntime = characterRuntime;
        this.stringCallback = stringCallback;
    }

    protected void m_7856_() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_267719_();
        super.m_7856_();
    }

    private void addTitle() {
        this.layout.m_269471_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_));
    }

    protected void addContents() {
        this.skinList = new SkinList(this.f_96541_, this.characterRuntime.getCharacterSkinController().getSkins());
        this.m_142416_((GuiEventListener)this.skinList);
    }

    private void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    protected void m_267719_() {
        this.layout.m_264036_();
        this.skinList.m_93437_(this.f_96543_, this.f_96544_, this.layout.m_269355_(), this.f_96544_ - this.layout.m_269040_());
    }

    public void m_7379_() {
        SkinList.Entry entry = (SkinList.Entry)this.skinList.m_93511_();
        if (entry != null) {
            File selectedSkin = entry.skin;
            this.characterRuntime.getCharacterSkinController().setCurrentSkin(selectedSkin);
            this.handleSkin(selectedSkin.getName());
        }
        this.f_96541_.m_91152_(this.lastScreen);
    }

    private void handleSkin(String skin) {
        this.stringCallback.accept(skin);
    }

    class SkinList
    extends ObjectSelectionList<Entry> {
        public SkinList(Minecraft minecraft, List<File> skins) {
            super(minecraft, ChangeSkinLinkScreen.this.f_96543_, ChangeSkinLinkScreen.this.f_96544_, 32, ChangeSkinLinkScreen.this.f_96544_ - 65, 18);
            String selectedSkin = ChangeSkinLinkScreen.this.characterRuntime.getCharacterSkinController().getCurrentSkin() != null ? ChangeSkinLinkScreen.this.characterRuntime.getCharacterSkinController().getCurrentSkin().getName() : "";
            skins.forEach(file -> {
                Entry entry = new Entry((File)file);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                if (selectedSkin.equalsIgnoreCase(file.getName())) {
                    this.m_6987_((AbstractSelectionList.Entry)entry);
                }
            });
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            }
        }

        public int m_5759_() {
            return super.m_5759_() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final File skin;

            public Entry(File skin) {
                this.skin = skin;
            }

            public void m_6311_(GuiGraphics p_345300_, int p_345469_, int p_345328_, int p_345700_, int p_345311_, int p_345185_, int p_344805_, int p_345963_, boolean p_345912_, float p_346091_) {
                p_345300_.m_280137_(ChangeSkinLinkScreen.this.f_96547_, this.skin.getName().split("\\.")[0], SkinList.this.f_93388_ / 2, p_345328_ + p_345185_ / 2 - 4, -1);
            }

            public boolean m_7933_(int p_346403_, int p_345881_, int p_345858_) {
                if (CommonInputs.m_278691_((int)p_346403_)) {
                    this.select();
                    ChangeSkinLinkScreen.this.m_7379_();
                    return true;
                }
                return super.m_7933_(p_346403_, p_345881_, p_345858_);
            }

            public boolean m_6375_(double p_344965_, double p_345385_, int p_345080_) {
                this.select();
                return super.m_6375_(p_344965_, p_345385_, p_345080_);
            }

            private void select() {
                SkinList.this.m_6987_((AbstractSelectionList.Entry)this);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.skin.getName());
            }
        }
    }
}

