/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import com.bladecoder.ink.runtime.Choice;
import fr.loudo.narrativecraft.narrative.story.text.ParsedDialog;
import fr.loudo.narrativecraft.narrative.story.text.TextEffectAnimation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import org.joml.Vector2f;

public class ChoiceButtonWidget
extends AbstractButton {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final int index;
    private final int paddingX;
    private final int paddingY;
    private final int hoverWidth;
    private final boolean hoverBorder;
    private final Consumer<Integer> onPress;
    private int backgroundColor;
    private int textColor;
    private int hoverColor;
    private final ParsedDialog parsedDialog;
    private final TextEffectAnimation textEffectAnimation;
    private boolean canPress;

    public ChoiceButtonWidget(Choice choice, Consumer<Integer> onPress) {
        super(0, 0, 0, 0, (Component)Component.m_237113_((String)choice.getText()));
        Font font = Minecraft.m_91087_().f_91062_;
        this.onPress = onPress;
        String choiceString = this.m_6035_().getString();
        this.index = choice.getIndex();
        this.paddingX = 9;
        this.paddingY = 6;
        this.backgroundColor = 0;
        this.textColor = 0xFFFFFF;
        this.hoverColor = 0xFFFFFF;
        this.hoverBorder = true;
        this.hoverWidth = 1;
        this.canPress = true;
        this.parsedDialog = ParsedDialog.parse(choiceString);
        int width = font.m_92895_(this.parsedDialog.cleanedText());
        Objects.requireNonNull(font);
        int height = 9;
        this.m_93674_(width + this.paddingX * 2);
        this.f_93619_ = height + this.paddingY * 2;
        this.textEffectAnimation = new TextEffectAnimation(this.parsedDialog);
    }

    public void tick() {
        this.textEffectAnimation.tick();
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int left = this.m_252754_();
        int top = this.m_252907_();
        int right = left + this.m_5711_();
        int bottom = top + this.m_93694_();
        if (this.f_93622_ && this.hoverBorder && this.canPress) {
            guiGraphics.m_280509_(left - this.hoverWidth, top - this.hoverWidth, right + this.hoverWidth, bottom + this.hoverWidth, this.hoverColor);
        }
        guiGraphics.m_280509_(left, top, right, bottom, this.backgroundColor);
        Map<Integer, Vector2f> letterOffsets = this.textEffectAnimation.getOffsets(partialTick);
        float startX = left + this.paddingX;
        for (int i = 0; i < this.parsedDialog.cleanedText().length(); ++i) {
            Vector2f offset = letterOffsets.getOrDefault(i, new Vector2f(0.0f, 0.0f));
            String character = String.valueOf(this.parsedDialog.cleanedText().charAt(i));
            this.minecraft.f_91062_.m_271703_(character, startX + offset.x, (float)(top + this.paddingY + 1) + offset.y, this.textColor, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            startX += Util.getLetterWidth(this.parsedDialog.cleanedText().codePointAt(i), this.minecraft);
        }
    }

    public void m_5691_() {
        if (!this.canPress) {
            return;
        }
        this.onPress.accept(this.index);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_) {
            boolean flag;
            if (this.m_7972_(button) && (flag = this.m_5953_(mouseX, mouseY))) {
                this.m_5716_(mouseX, mouseY);
                return true;
            }
            return false;
        }
        return false;
    }

    public void setOpacity(int opacity) {
        this.backgroundColor = FastColor.ABGR32.m_266498_((int)opacity, (int)this.backgroundColor);
        this.textColor = FastColor.ABGR32.m_266498_((int)opacity, (int)this.textColor);
        this.hoverColor = FastColor.ABGR32.m_266498_((int)opacity, (int)this.hoverColor);
    }

    public boolean isCanPress() {
        return this.canPress;
    }

    public void setCanPress(boolean canPress) {
        this.canPress = canPress;
    }
}

