/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class PickElementScreen
extends Screen {
    private static final Component AVAILABLE_TITLE = Component.m_237115_((String)"pack.available.title");
    private static final Component SELECTED_TITLE = Component.m_237115_((String)"pack.selected.title");
    private static final int LIST_WIDTH = 200;
    private final Screen lastScreen;
    private final List<? extends NarrativeEntry> availableEntries;
    private final List<? extends NarrativeEntry> selectedEntries;
    private final Component selector;
    private final Consumer<List<TransferableStorySelectionList.Entry>> onDone;
    private Button doneButton;
    private Button moveButton;
    private TransferableStorySelectionList availableList;
    private TransferableStorySelectionList selectedList;

    public PickElementScreen(Screen lastScreen, Component title, Component selector, List<? extends NarrativeEntry> availableEntries, List<? extends NarrativeEntry> selectedEntries, Consumer<List<TransferableStorySelectionList.Entry>> onDone) {
        super(title);
        this.lastScreen = lastScreen;
        this.selector = selector;
        this.availableEntries = availableEntries;
        this.selectedEntries = selectedEntries;
        this.onDone = onDone;
    }

    protected void m_7856_() {
        this.availableList = new TransferableStorySelectionList(this.f_96541_, this, this.availableEntries, 200, this.f_96544_, (Component)Component.m_237113_((String)(this.selector.getString() + " " + AVAILABLE_TITLE.getString())));
        this.availableList.m_93507_(this.f_96543_ / 2 - 18 - 200);
        this.m_7787_((GuiEventListener)this.availableList);
        this.selectedList = new TransferableStorySelectionList(this.f_96541_, this, this.selectedEntries, 200, this.f_96544_, (Component)Component.m_237113_((String)(this.selector.getString() + " " + SELECTED_TITLE.getString())));
        this.selectedList.m_93507_(this.f_96543_ / 2 + 18);
        this.m_7787_((GuiEventListener)this.selectedList);
        this.availableList.setOtherList(this.selectedList);
        this.selectedList.setOtherList(this.availableList);
        this.moveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25b6"), button -> {
            if (this.availableList.m_93511_() != null) {
                TransferableStorySelectionList.Entry selected = (TransferableStorySelectionList.Entry)this.availableList.m_93511_();
                this.availableList.m_6702_().remove((Object)selected);
                this.selectedList.m_6702_().add(selected);
                this.selectedList.setSelected(selected);
                this.availableList.setSelected(null);
                this.moveButton.m_93666_((Component)Component.m_237113_((String)"\u25c0"));
            } else if (this.selectedList.m_93511_() != null) {
                TransferableStorySelectionList.Entry selected = (TransferableStorySelectionList.Entry)this.selectedList.m_93511_();
                this.selectedList.m_6702_().remove((Object)selected);
                this.availableList.m_6702_().add(selected);
                this.availableList.setSelected(selected);
                this.selectedList.setSelected(null);
                this.moveButton.m_93666_((Component)Component.m_237113_((String)"\u25b6"));
            }
            this.updateMoveButton();
        }).m_252987_(this.f_96543_ / 2 - 10, this.f_96544_ / 2 - 10, 20, 20).m_253136_());
        this.moveButton.f_93623_ = false;
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone.accept(this.selectedList.m_6702_())).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 48, 200, 20).m_253136_());
    }

    private void updateMoveButton() {
        if (this.moveButton != null) {
            boolean hasSelection;
            this.moveButton.f_93623_ = hasSelection = this.availableList.m_93511_() != null || this.selectedList.m_93511_() != null;
            if (this.availableList.m_93511_() != null) {
                this.moveButton.m_93666_((Component)Component.m_237113_((String)"\u25b6"));
            } else if (this.selectedList.m_93511_() != null) {
                this.moveButton.m_93666_((Component)Component.m_237113_((String)"\u25c0"));
            }
        }
    }

    public void clearSelected() {
        this.selectedList.setSelected(null);
        this.availableList.setSelected(null);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.availableList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.selectedList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public class TransferableStorySelectionList
    extends ObjectSelectionList<Entry> {
        private TransferableStorySelectionList otherList;
        private final Component title;
        private final PickElementScreen screen;

        public TransferableStorySelectionList(Minecraft minecraft, PickElementScreen screen, List<? extends NarrativeEntry> narrativeEntries, int width, int height, Component title) {
            super(minecraft, width, height, 32, height - 55 + 4, 18);
            this.screen = screen;
            this.title = title;
            this.f_93394_ = false;
            this.m_93473_(true, 13);
            for (NarrativeEntry narrativeEntry : narrativeEntries) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(narrativeEntry));
            }
        }

        public void setOtherList(TransferableStorySelectionList otherList) {
            this.otherList = otherList;
        }

        public void m_93507_(int x) {
            this.f_93393_ = x;
            this.f_93392_ = x + this.f_93388_;
        }

        protected void m_7415_(GuiGraphics guiGraphics, int x, int y) {
            MutableComponent component = Component.m_237119_().m_7220_(this.title).m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(this.f_93386_.f_91062_, (Component)component, x + this.f_93388_ / 2 - this.f_93386_.f_91062_.m_92852_((FormattedText)component) / 2, Math.min(this.f_93390_ + 3, y), 0xFFFFFF, false);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public void setSelected(@Nullable Entry selected) {
            super.m_6987_((AbstractSelectionList.Entry)selected);
            if (this.otherList != null && selected != null) {
                this.otherList.setSelected(null);
            }
            PickElementScreen.this.updateMoveButton();
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final NarrativeEntry narrativeEntry;

            public Entry(NarrativeEntry narrativeEntry) {
                this.narrativeEntry = narrativeEntry;
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.narrativeEntry.getName());
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int textWidth = ((TransferableStorySelectionList)TransferableStorySelectionList.this).f_93386_.f_91062_.m_92895_(this.narrativeEntry.getName());
                int centeredX = left + (width - textWidth) / 2;
                guiGraphics.m_280488_(((TransferableStorySelectionList)TransferableStorySelectionList.this).f_93386_.f_91062_, this.narrativeEntry.getName(), centeredX, top + 2, 0xFFFFFF);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    TransferableStorySelectionList.this.setSelected(this);
                    PickElementScreen.this.clearSelected();
                    TransferableStorySelectionList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            public NarrativeEntry getNarrativeEntry() {
                return this.narrativeEntry;
            }
        }
    }
}

