/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cameraAngle;

import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cameraAngle.CameraAngleKeyframe;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.EntryBoxScreen;
import fr.loudo.narrativecraft.screens.components.KeyframeOptionScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CameraAngleOptionsScreen
extends KeyframeOptionScreen<CameraAngleKeyframe, CameraAngleController> {
    public CameraAngleOptionsScreen(CameraAngleKeyframe keyframe, CameraAngleController keyframeController, PlayerSession playerSession, boolean hide) {
        super(keyframe, keyframeController, playerSession, hide);
        this.reloadScreen = () -> this.f_96541_.m_91152_((Screen)new CameraAngleOptionsScreen(keyframe, keyframeController, playerSession, false));
    }

    @Override
    protected void m_7856_() {
        if (!this.hide) {
            this.initPositionLabelBox();
            this.initButtons();
            this.initSliders();
            this.initTextSelectedKeyframe();
        }
        this.initLittleButtons();
        this.currentY = 15;
    }

    public void m_7379_() {
    }

    @Override
    protected void initLittleButtons() {
        super.initLittleButtons();
        if (this.hide) {
            return;
        }
        Button editButton = Button.m_253074_((Component)ImageFontConstants.EDIT, button -> {
            EntryBoxScreen screen = new EntryBoxScreen(this, (Component)Translation.message("global.name", new Object[0]), ((CameraAngleKeyframe)this.keyframe).getName(), name -> {
                if (name.isEmpty()) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("camera_angle.name_no_empty", name, ((CameraAngleController)this.keyframeController).getCameraAngle().getName()));
                } else if (((CameraAngleController)this.keyframeController).getKeyframeByName((String)name) != null) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("camera_angle.already_exists", name, ((CameraAngleController)this.keyframeController).getCameraAngle().getName()));
                } else {
                    this.f_96541_.f_91066_.f_92062_ = true;
                    ((CameraAngleKeyframe)this.keyframe).setName((String)name);
                    this.m_7379_();
                }
            });
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(((Button)this.littleButtons.get(this.littleButtons.size() - 1)).m_252754_() - 25, 10, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)editButton);
    }

    @Override
    protected void initTextSelectedKeyframe() {
        int y = 10;
        String cameraAngleName = ((CameraAngleKeyframe)this.keyframe).getName();
        this.m_142416_((GuiEventListener)ScreenUtils.text((Component)Component.m_237113_((String)cameraAngleName), this.f_96547_, this.f_96543_ / 2 - this.f_96547_.m_92895_(cameraAngleName) / 2, y));
    }

    @Override
    protected void initButtons() {
        MutableComponent updateTitle = Translation.message("screen.keyframe_option.update", new Object[0]);
        Button updateButton = Button.m_253074_((Component)updateTitle, button -> this.updateValues()).m_252987_(20, this.currentY, this.f_96547_.m_92852_((FormattedText)updateTitle) + 30, 20).m_253136_();
        this.m_142416_((GuiEventListener)updateButton);
        this.currentY += 35;
        MutableComponent removeTitle = Translation.message("global.remove", new Object[0]);
        Button removeKeyframe = Button.m_253074_((Component)removeTitle, button -> {
            ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                if (b) {
                    if (this.playerSession != null) {
                        ((CameraAngleController)this.keyframeController).setCamera(null);
                        ((CameraAngleController)this.keyframeController).removeKeyframe((CameraAngleKeyframe)this.keyframe);
                        this.f_96541_.m_91152_(null);
                    }
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237113_((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
            this.f_96541_.m_91152_((Screen)confirmScreen);
        }).m_252987_(20, this.currentY, this.f_96547_.m_92852_((FormattedText)removeTitle) + 15, 20).m_253136_();
        this.m_142416_((GuiEventListener)removeKeyframe);
    }

    @Override
    protected void updateValues() {
        KeyframeLocation position = ((CameraAngleKeyframe)this.keyframe).getKeyframeLocation();
        try {
            float xVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(0)).m_94155_());
            float yVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(1)).m_94155_());
            float zVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(2)).m_94155_());
            position.setX(xVal);
            position.setY(yVal);
            position.setZ(zVal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        position.setPitch(this.upDownValue);
        position.setYaw(this.leftRightValue);
        position.setRoll(this.rotationValue);
        position.setFov(this.fovValue);
        ((CameraAngleKeyframe)this.keyframe).setKeyframeLocation(position);
        ((CameraAngleKeyframe)this.keyframe).updateEntityData(this.player);
    }
}

