/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.KeyframeOptionScreen;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneKeyframeAdvancedSettings;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CutsceneKeyframeOptionScreen
extends KeyframeOptionScreen<CutsceneKeyframe, CutsceneController> {
    private final CutsceneController cutsceneController;
    private final CutsceneKeyframeGroup cutsceneKeyframeGroup;
    private EditBox startDelayBox;
    private EditBox pathTimeBox;
    private EditBox transitionDelayBox;
    private EditBox speedBox;

    public CutsceneKeyframeOptionScreen(CutsceneKeyframe keyframe, PlayerSession playerSession, boolean hide) {
        super(keyframe, (CutsceneController)playerSession.getController(), playerSession, hide);
        this.cutsceneController = (CutsceneController)playerSession.getController();
        this.cutsceneKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(keyframe);
        this.reloadScreen = () -> this.f_96541_.m_91152_((Screen)new CutsceneKeyframeOptionScreen(keyframe, playerSession, false));
    }

    @Override
    protected void m_7856_() {
        if (!this.hide) {
            if (!((CutsceneKeyframe)this.keyframe).isParentGroup()) {
                this.pathTimeBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.path_time", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getPathTick())));
                this.speedBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.speed", new Object[0]), String.valueOf(((CutsceneKeyframe)this.keyframe).getSpeed()));
            }
            if (this.cutsceneKeyframeGroup.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
                this.transitionDelayBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.transition_delay", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getTransitionDelayTick())));
            } else {
                this.startDelayBox = this.addLabeledEditBox((Component)Translation.message("screen.keyframe_option.start_delay", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getStartDelayTick())));
            }
            this.initPositionLabelBox();
            this.initSliders();
            this.initButtons();
            this.initTextSelectedKeyframe();
        }
        this.initLittleButtons();
        this.currentY = 15;
    }

    public void m_7379_() {
    }

    @Override
    protected void initButtons() {
        int gap = 15;
        int margin = 15;
        MutableComponent updateTitle = Translation.message("screen.keyframe_option.update", new Object[0]);
        Button updateButton = Button.m_253074_((Component)updateTitle, button -> {
            this.updateValues();
            this.cutsceneController.updateCurrentTick(((CutsceneKeyframe)this.keyframe).getTick());
            this.cutsceneController.changeTimePosition(((CutsceneKeyframe)this.keyframe).getTick(), true);
        }).m_252987_(20, this.currentY, this.f_96547_.m_92852_((FormattedText)updateTitle) + margin, 20).m_253136_();
        MutableComponent playTitle = Translation.message("screen.keyframe_option.play_from_here", new Object[0]);
        Button playFromHere = Button.m_253074_((Component)playTitle, button -> {
            if (this.playerSession != null) {
                CutscenePlayback cutscenePlayback = this.cutsceneController.getCutscenePlayback();
                if (this.cutsceneKeyframeGroup.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
                    if (this.cutsceneKeyframeGroup.getKeyframes().size() > 1) {
                        CutsceneKeyframe previous = this.cutsceneController.getPreviousKeyframe((CutsceneKeyframe)this.keyframe);
                        cutscenePlayback.setupAndPlay(previous, (CutsceneKeyframe)this.keyframe);
                        int offset = ((CutsceneKeyframe)this.keyframe).getTick() - previous.getTick();
                        cutscenePlayback.setSegmentTick(offset);
                        cutscenePlayback.setTotalTick(previous.getTick() + offset);
                    } else {
                        cutscenePlayback.setupAndPlay((CutsceneKeyframe)this.keyframe, (CutsceneKeyframe)this.keyframe);
                    }
                } else {
                    cutscenePlayback.setupAndPlay((CutsceneKeyframe)this.keyframe, this.cutsceneController.getNextKeyframe((CutsceneKeyframe)this.keyframe));
                }
                NarrativeCraftMod.server.execute(() -> this.cutsceneController.setPlaying(true));
                this.f_96541_.m_91152_(null);
            }
        }).m_252987_(updateButton.m_5711_() + updateButton.m_252754_() + 5, this.currentY, this.f_96547_.m_92852_((FormattedText)playTitle) + margin, 20).m_253136_();
        this.currentY += 20 + gap - 10;
        MutableComponent advancedTitle = Translation.message("global.advanced", new Object[0]);
        Button advancedButton = Button.m_253074_((Component)advancedTitle, button -> {
            CutsceneKeyframeAdvancedSettings screen = new CutsceneKeyframeAdvancedSettings((Screen)this, (CutsceneKeyframe)this.keyframe);
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(20, this.currentY, this.f_96547_.m_92852_((FormattedText)advancedTitle) + margin, 20).m_253136_();
        this.currentY += 20 + gap;
        MutableComponent removeTitle = Translation.message("global.remove", new Object[0]);
        Button removeKeyframe = Button.m_253074_((Component)removeTitle, button -> {
            ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                if (b) {
                    if (this.playerSession != null) {
                        this.cutsceneController.setCamera(null);
                        this.cutsceneController.removeKeyframe((CutsceneKeyframe)this.keyframe);
                        this.cutsceneController.updateCurrentTick(((CutsceneKeyframe)this.keyframe).getTick());
                        this.f_96541_.m_91152_(null);
                    }
                } else {
                    CutsceneKeyframeOptionScreen screen = new CutsceneKeyframeOptionScreen((CutsceneKeyframe)this.keyframe, this.playerSession, false);
                    this.f_96541_.m_91152_((Screen)screen);
                }
            }, (Component)Component.m_237113_((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
            this.f_96541_.m_91152_((Screen)confirmScreen);
        }).m_252987_(20, this.currentY, this.f_96547_.m_92852_((FormattedText)removeTitle) + margin, 20).m_253136_();
        this.m_142416_((GuiEventListener)updateButton);
        this.m_142416_((GuiEventListener)advancedButton);
        if (!this.cutsceneController.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
            this.m_142416_((GuiEventListener)playFromHere);
        }
        this.m_142416_((GuiEventListener)removeKeyframe);
    }

    @Override
    protected void initTextSelectedKeyframe() {
        int y = 10;
        MutableComponent groupText = Translation.message("screen.keyframe_option.keyframe_group", this.cutsceneKeyframeGroup.getId());
        MutableComponent keyframeText = Translation.message("screen.keyframe_option.keyframe_id", ((CutsceneKeyframe)this.keyframe).getId());
        MutableComponent keyframeTickText = Translation.message("screen.keyframe_option.tick", ((CutsceneKeyframe)this.keyframe).getTick());
        int groupWidth = this.f_96547_.m_92852_((FormattedText)groupText);
        int keyframeWidth = this.f_96547_.m_92852_((FormattedText)keyframeText);
        int keyframeTickWidth = this.f_96547_.m_92852_((FormattedText)keyframeTickText);
        int spacing = 5;
        int totalWidth = groupWidth + spacing + keyframeWidth + spacing + keyframeTickWidth;
        int startX = (this.f_96543_ - totalWidth) / 2;
        StringWidget groupLabel = ScreenUtils.text((Component)groupText, this.f_96547_, startX, y, 2608927);
        StringWidget keyframeIdLabel = ScreenUtils.text((Component)keyframeText, this.f_96547_, startX + groupWidth + spacing, y, 15844367);
        StringWidget keyframeTickLabel = ScreenUtils.text((Component)keyframeTickText, this.f_96547_, startX + groupWidth + spacing + keyframeWidth + spacing, y, -1);
        this.m_142416_((GuiEventListener)groupLabel);
        this.m_142416_((GuiEventListener)keyframeIdLabel);
        this.m_142416_((GuiEventListener)keyframeTickLabel);
    }

    @Override
    protected void updateValues() {
        if (this.startDelayBox != null) {
            try {
                float startDelayVal = Float.parseFloat(this.startDelayBox.m_94155_());
                ((CutsceneKeyframe)this.keyframe).setStartDelayTick(MathHelper.secondsToTick(startDelayVal));
            }
            catch (NumberFormatException startDelayVal) {
                // empty catch block
            }
        }
        if (this.transitionDelayBox != null) {
            try {
                float transitionDelayValue = Float.parseFloat(this.transitionDelayBox.m_94155_());
                ((CutsceneKeyframe)this.keyframe).setTransitionDelayTick(MathHelper.secondsToTick(transitionDelayValue));
            }
            catch (NumberFormatException transitionDelayValue) {
                // empty catch block
            }
        }
        if (this.speedBox != null) {
            try {
                double speedValue = Double.parseDouble(this.speedBox.m_94155_());
                ((CutsceneKeyframe)this.keyframe).setSpeed(speedValue);
            }
            catch (NumberFormatException speedValue) {
                // empty catch block
            }
        }
        try {
            float pathTimeVal = this.pathTimeBox == null ? 0.0f : Float.parseFloat(this.pathTimeBox.m_94155_());
            ((CutsceneKeyframe)this.keyframe).setPathTick(MathHelper.secondsToTick(pathTimeVal));
        }
        catch (NumberFormatException pathTimeVal) {
            // empty catch block
        }
        KeyframeLocation location = this.getKeyframeLocation();
        ((CutsceneKeyframe)this.keyframe).setKeyframeLocation(location);
        ((CutsceneKeyframe)this.keyframe).updateEntityData(this.player);
    }

    private KeyframeLocation getKeyframeLocation() {
        KeyframeLocation location = ((CutsceneKeyframe)this.keyframe).getKeyframeLocation();
        location.setPitch(this.upDownValue);
        location.setYaw(this.leftRightValue);
        location.setRoll(this.rotationValue);
        try {
            float xVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(0)).m_94155_());
            float yVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(1)).m_94155_());
            float zVal = Float.parseFloat(((EditBox)this.coordinatesBoxList.get(2)).m_94155_());
            location.setX(xVal);
            location.setY(yVal);
            location.setZ(zVal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        location.setFov(this.fovValue);
        return location;
    }
}

