/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.interaction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.CharacterInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.components.EntryBoxScreen;
import fr.loudo.narrativecraft.screens.storyManager.areaTrigger.AreaTriggersScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class InteractionControllerScreen
extends Screen {
    private final int BUTTON_HEIGHT = 20;
    private final int BUTTON_WIDTH = 30;
    private final InteractionController controller;

    public InteractionControllerScreen(InteractionController controller) {
        super((Component)Component.m_237113_((String)"Interaction Controller Screen"));
        this.controller = controller;
    }

    protected void m_7856_() {
        int spacing = 5;
        int totalWidth = 150 + spacing * 3;
        int startX = (this.f_96543_ - totalWidth) / 2;
        int y = this.f_96544_ - 50;
        Button addCharacter = Button.m_253074_((Component)ImageFontConstants.CHARACTER_ADD, button -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((Screen)this, Translation.message("controller.add_character", this.controller.getInteraction().getName()).getString(), null, this.controller.getInteraction().getScene(), characterStory -> {
                if (characterStory == null) {
                    this.m_7379_();
                    return;
                }
                Location location = this.controller.getPlayerSession().getPlayerPosition();
                CharacterStoryData characterStoryData = new CharacterStoryData((CharacterStory)characterStory, location, true, this.controller.getInteraction().getScene());
                characterStoryData.setItems((LivingEntity)this.f_96541_.f_91074_);
                characterStoryData.setEntityByte((Byte)this.f_96541_.f_91074_.m_20088_().m_135370_(EntityAccessor.getDATA_SHARED_FLAGS_ID()));
                characterStoryData.setLivingEntityByte((Byte)this.f_96541_.f_91074_.m_20088_().m_135370_(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS()));
                characterStoryData.spawn(this.controller.getPlayerSession().getPlayer().m_9236_(), Environment.DEVELOPMENT);
                this.controller.getCharacterStoryDataList().add(characterStoryData);
                this.f_96541_.m_91152_(null);
                this.controller.getPlayerSession().getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
                CharacterInteraction characterInteraction = new CharacterInteraction("", characterStoryData);
                EntryBoxScreen screen1 = new EntryBoxScreen(null, (Component)Translation.message("global.stitch", new Object[0]), characterInteraction::setStitch);
                this.controller.getCharacterInteractions().add(characterInteraction);
                this.f_96541_.m_91152_((Screen)screen1);
            });
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(startX, y, 30, 20).m_253136_();
        addCharacter.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.add_character", new Object[0])));
        this.m_142416_((GuiEventListener)addCharacter);
        Button addEntityInteractionBtn = Button.m_253074_((Component)ImageFontConstants.EYE_OPEN, button -> {
            EntryBoxScreen screen = new EntryBoxScreen(this, (Component)Translation.message("global.stitch", new Object[0]), s -> {
                Vec3 position = this.controller.getPlayerSession().getPlayerPosition().asVec3();
                EntityInteraction entityInteraction = new EntityInteraction((String)s, position);
                this.controller.getEntityInteractions().add(entityInteraction);
                entityInteraction.spawn(this.controller.getPlayerSession().getPlayer(), this.controller.getEnvironment());
            });
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(startX + (30 + spacing) * 1, y, 30, 20).m_253136_();
        addEntityInteractionBtn.m_257544_(Tooltip.m_257550_((Component)Translation.message("controller.interaction.add_entity_interaction", new Object[0])));
        this.m_142416_((GuiEventListener)addEntityInteractionBtn);
        Button areaTriggerMode = Button.m_253074_((Component)ImageFontConstants.BOX, button -> {
            AreaTriggersScreen screen = new AreaTriggersScreen(this, this.controller);
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(startX + (30 + spacing) * 2, y, 30, 20).m_253136_();
        areaTriggerMode.m_257544_(Tooltip.m_257550_((Component)Translation.message("controller.interaction.area_trigger_list", new Object[0])));
        this.m_142416_((GuiEventListener)areaTriggerMode);
        Button saveButton = Button.m_253074_((Component)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.controller.stopSession(true));
            this.m_7379_();
        }).m_252987_(startX + (30 + spacing) * 3, y, 30, 20).m_253136_();
        this.m_142416_((GuiEventListener)saveButton);
        Button closeButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2716"), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.controller.stopSession(false));
                    this.m_7379_();
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237113_((String)""), (Component)Translation.message("controller.confirm_leaving", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
            this.f_96541_.m_91152_((Screen)confirm);
        }).m_252987_(startX + (30 + spacing) * 4, y, 30, 20).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public boolean m_7043_() {
        return false;
    }
}

