/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.keyframe;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionRegistry;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.controllers.mainScreen.MainScreenController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.story.inkAction.OnEnterInkAction;
import fr.loudo.narrativecraft.narrative.story.inkAction.SaveInkAction;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class KeyframeTriggerScreen
extends Screen {
    private final int gap = 5;
    private final int tickBoxHeight = 20;
    private final int tickBoxWidth = 60;
    private final int commandBoxHeight = 120;
    private final int globalWidth = 240;
    private int defaultTick;
    private ScreenUtils.LabelBox tickBox;
    private ScreenUtils.MultilineLabelBox commandBox;
    private AbstractKeyframeController<? extends Keyframe> controller;
    private KeyframeTrigger keyframeTrigger;

    public KeyframeTriggerScreen(AbstractKeyframeController<? extends Keyframe> controller, KeyframeTrigger keyframeTrigger) {
        super((Component)Component.m_237113_((String)"Keyframe Trigger Screen"));
        this.controller = controller;
        this.keyframeTrigger = keyframeTrigger;
        this.defaultTick = keyframeTrigger.getTick();
    }

    public KeyframeTriggerScreen(AbstractKeyframeController<? extends Keyframe> controller, int defaultTick) {
        super((Component)Component.m_237113_((String)"Keyframe Trigger Screen"));
        this.controller = controller;
        this.defaultTick = defaultTick;
    }

    protected void m_7856_() {
        int totalHeight = 195;
        if (this.keyframeTrigger != null) {
            totalHeight += 45;
        }
        int startY = (this.f_96544_ - totalHeight) / 2;
        int xGlobal = (this.f_96543_ - 240) / 2;
        Objects.requireNonNull(this.f_96541_.f_91062_);
        StringWidget tagWidget = new StringWidget(0, startY - 9 - 30, 100, 40, (Component)Component.m_237119_(), this.f_96541_.f_91062_);
        this.m_142416_((GuiEventListener)tagWidget);
        Objects.requireNonNull(this.f_96541_.f_91062_);
        StringWidget errorWidget = new StringWidget(0, startY - 9 - 20, 100, 40, (Component)Component.m_237119_(), this.f_96541_.f_91062_);
        this.m_142416_((GuiEventListener)errorWidget);
        int currentY = startY;
        this.tickBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Tick"), this.f_96541_.f_91062_, 60, 20, xGlobal, currentY, ScreenUtils.Align.HORIZONTAL);
        this.tickBox.getEditBox().m_94153_(s -> s.matches("^(?:[0-9]+)?$"));
        this.m_142416_((GuiEventListener)this.tickBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.tickBox.getEditBox());
        this.commandBox = new ScreenUtils.MultilineLabelBox((Component)Component.m_237113_((String)"Tags"), this.f_96541_.f_91062_, 240, 120, xGlobal, currentY += 25, (Component)Component.m_237113_((String)"animation start cathy_walk\ntime set 6000 to 90000 for 6 seconds\n..."));
        this.m_142416_((GuiEventListener)this.commandBox.getStringWidget());
        this.m_142416_((GuiEventListener)this.commandBox.getMultiLineEditBox());
        Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            List<String> tags = Arrays.asList(this.commandBox.getMultiLineEditBox().m_239249_().split("\n"));
            for (String tag : tags) {
                String stringTag = "\"" + tag + "\"";
                int tagWidth = this.f_96541_.f_91062_.m_92895_(stringTag);
                tagWidget.m_93674_(tagWidth);
                tagWidget.m_252865_(this.f_96543_ / 2 - tagWidth / 2);
                InkAction inkAction = InkActionRegistry.findByCommand(tag);
                if (inkAction instanceof SaveInkAction || inkAction instanceof OnEnterInkAction) {
                    this.showError(tagWidget, errorWidget, stringTag, (Component)Translation.message("ink_action.not_authorized", stringTag));
                    return;
                }
                if (inkAction == null) {
                    this.showError(tagWidget, errorWidget, stringTag, (Component)Translation.message("ink_action.no_exists", new Object[0]));
                    return;
                }
                if (this.controller instanceof MainScreenController && inkAction.needScene()) {
                    this.showError(tagWidget, errorWidget, stringTag, (Component)Translation.message("ink_action.not_authorized", stringTag));
                    return;
                }
                InkActionResult result = inkAction.validate(tag, this.controller.getPlayerSession().getScene());
                if (!result.isError()) continue;
                this.showError(tagWidget, errorWidget, stringTag, (Component)Component.m_237113_((String)result.errorMessage()));
                return;
            }
            int tick = this.defaultTick;
            try {
                tick = Integer.parseInt(this.tickBox.getEditBox().m_94155_());
            }
            catch (NumberFormatException tag) {
                // empty catch block
            }
            String commands = this.commandBox.getMultiLineEditBox().m_239249_();
            if (this.keyframeTrigger == null) {
                this.controller.addKeyframeTrigger(tick, commands);
            } else {
                this.keyframeTrigger.setTick(tick);
                this.keyframeTrigger.setCommands(commands);
            }
            this.m_7379_();
        }).m_252780_(240).m_252794_(xGlobal, currentY += 120 + this.commandBox.getStringWidget().m_93694_() + 10).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        Button closeButton = Button.m_253074_((Component)Translation.message("global.close", new Object[0]), button -> this.m_7379_()).m_252780_(240).m_252794_(xGlobal, currentY += 25).m_253136_();
        this.m_142416_((GuiEventListener)closeButton);
        if (this.keyframeTrigger != null) {
            Button removeButton = Button.m_253074_((Component)Translation.message("global.remove", new Object[0]), button -> {
                ConfirmScreen confirmScreen = new ConfirmScreen(b -> {
                    if (b) {
                        this.controller.removeKeyframeTrigger(this.keyframeTrigger);
                        this.m_7379_();
                    } else {
                        KeyframeTriggerScreen screen = new KeyframeTriggerScreen(this.controller, this.keyframeTrigger);
                        this.f_96541_.m_91152_((Screen)screen);
                    }
                }, (Component)Component.m_237113_((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
                this.f_96541_.m_91152_((Screen)confirmScreen);
            }).m_252780_(240).m_252794_(xGlobal, currentY += 25).m_253136_();
            this.m_142416_((GuiEventListener)removeButton);
        }
        if (this.keyframeTrigger != null) {
            this.tickBox.getEditBox().m_94144_(String.valueOf(this.keyframeTrigger.getTick()));
            this.commandBox.getMultiLineEditBox().m_240159_(this.keyframeTrigger.getCommands());
        } else {
            this.tickBox.getEditBox().m_94144_(String.valueOf(this.defaultTick));
        }
    }

    private void showError(StringWidget tagWidget, StringWidget errorWidget, String stringTag, Component errorMessage) {
        tagWidget.m_93666_((Component)Component.m_237113_((String)stringTag).m_130940_(ChatFormatting.RED));
        errorWidget.m_93666_((Component)errorMessage.m_6881_().m_130940_(ChatFormatting.RED));
        int errorWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)errorMessage);
        errorWidget.m_93674_(errorWidth);
        errorWidget.m_252865_(this.f_96543_ / 2 - errorWidth / 2);
    }
}

