/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.options;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.options.NarrativeWorldOption;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class WorldOptionsScreen
extends StoryElementScreen {
    private final NarrativeWorldOption worldOption = NarrativeCraftMod.getInstance().getNarrativeWorldOption();
    private final Screen lastScreen;

    public WorldOptionsScreen(Screen lastScreen) {
        super((Component)Translation.message("screen.world_options.title", new Object[0]));
        this.lastScreen = lastScreen;
    }

    public void m_7379_() {
        NarrativeCraftFile.updateWorldOptions(this.worldOption);
        this.f_96541_.m_91152_(this.lastScreen);
    }

    @Override
    protected void addTitle() {
        this.layout.m_269471_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = List.of(this.createToggleButton(() -> this.worldOption.finishedStory, val -> {
            this.worldOption.finishedStory = val;
        }, "screen.world_options.finished_story"), this.createToggleButton(() -> this.worldOption.showMainScreen, val -> {
            this.worldOption.showMainScreen = val;
        }, "screen.world_options.show_main_screen"), this.createToggleButton(() -> this.worldOption.showCreditsScreen, val -> {
            this.worldOption.showCreditsScreen = val;
        }, "screen.world_options.show_credits_screen"));
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }

    private StoryElementList.StoryEntryData createToggleButton(BooleanSupplier getter, Consumer<Boolean> setter, String translationKey) {
        Button button = Button.m_253074_((Component)Translation.message(translationKey, this.yesOrNo(getter.getAsBoolean())), b -> {
            boolean newValue = !getter.getAsBoolean();
            setter.accept(newValue);
            b.m_93666_((Component)Translation.message(translationKey, this.yesOrNo(newValue)));
        }).m_253136_();
        return new StoryElementList.StoryEntryData(button);
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    @Override
    protected void openFolder() {
    }

    private Component yesOrNo(boolean b) {
        return b ? CommonComponents.f_130657_ : CommonComponents.f_130658_;
    }
}

