/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.story;

import com.bladecoder.ink.runtime.Choice;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.keys.ModKeys;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.components.ChoiceButtonWidget;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class StoryChoicesScreen
extends Screen {
    private static final double APPEAR_TIME = 0.25;
    private static final int OFFSET = 10;
    private final List<Choice> choiceList;
    private final List<AnimatedChoice> animatedChoices;
    private final List<ChoiceButtonWidget> choiceButtonWidgetList = new ArrayList<ChoiceButtonWidget>();
    private final int totalTick;
    private PlayerSession playerSession;
    private StoryHandler storyHandler;
    private boolean initiated;
    private double t;
    private int currentTick;

    public StoryChoicesScreen(PlayerSession playerSession, boolean animate) {
        super((Component)Component.m_237113_((String)"Choice screen"));
        this.playerSession = playerSession;
        this.storyHandler = playerSession.getStoryHandler();
        List choices = playerSession.getStoryHandler().getStory().getCurrentChoices();
        this.choiceList = choices.subList(0, Math.min(choices.size(), 4));
        this.animatedChoices = new ArrayList<AnimatedChoice>();
        this.initiated = !animate;
        this.totalTick = 5;
    }

    public StoryChoicesScreen(List<Choice> choiceList, boolean animate) {
        super((Component)Component.m_237113_((String)"Choice screen"));
        this.choiceList = choiceList.subList(0, Math.min(choiceList.size(), 4));
        this.animatedChoices = new ArrayList<AnimatedChoice>();
        this.initiated = !animate;
        this.totalTick = 5;
    }

    public static StoryChoicesScreen fromStrings(List<String> stringChoiceList) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (String choiceString : stringChoiceList) {
            Choice choice = new Choice();
            choice.setIndex(0);
            choice.setText(choiceString);
            choices.add(choice);
        }
        return new StoryChoicesScreen(choices, true);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.currentTick < this.totalTick) {
            ++this.currentTick;
        }
        for (ChoiceButtonWidget choiceButtonWidget : this.choiceButtonWidgetList) {
            choiceButtonWidget.tick();
        }
    }

    protected void m_7856_() {
        int i;
        if (!this.initiated) {
            ResourceLocation soundRes = new ResourceLocation("narrativecraft", "sfx.choice_appear");
            SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)soundRes);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)1.0f));
        }
        this.choiceButtonWidgetList.clear();
        for (Choice choice : this.choiceList) {
            choice.setText(choice.getText().replace("__username__", this.playerSession.getPlayer().m_7755_().getString()));
            this.choiceButtonWidgetList.add(new ChoiceButtonWidget(choice, index -> {
                this.f_96541_.m_91152_(null);
                NarrativeCraftMod.server.execute(() -> this.storyHandler.chooseChoiceAndNext((int)index));
            }));
        }
        int spacing = 10;
        int baseY = 60;
        int maxWidthUpDown = 0;
        for (i = 0; i < this.choiceButtonWidgetList.size(); ++i) {
            if (i % 2 == 0 || this.choiceButtonWidgetList.get(i).m_5711_() <= maxWidthUpDown) continue;
            maxWidthUpDown = this.choiceButtonWidgetList.get(i).m_5711_();
        }
        for (i = 0; i < this.choiceButtonWidgetList.size(); ++i) {
            ChoiceButtonWidget choiceButtonWidget = this.choiceButtonWidgetList.get(i);
            choiceButtonWidget.setOpacity(5);
            choiceButtonWidget.setCanPress(false);
            int currentX = 0;
            int offsetX = 0;
            int offsetY = 0;
            int currentY = this.f_96544_ - baseY;
            if (this.choiceButtonWidgetList.size() == 4) {
                currentY -= choiceButtonWidget.m_93694_();
            }
            switch (i) {
                case 0: {
                    currentX = this.choiceButtonWidgetList.size() == 1 ? this.f_96543_ / 2 - choiceButtonWidget.m_5711_() / 2 : (this.choiceButtonWidgetList.size() > 2 ? this.f_96543_ / 2 - choiceButtonWidget.m_5711_() - maxWidthUpDown / 2 : this.f_96543_ / 2 - choiceButtonWidget.m_5711_() - spacing);
                    offsetX = 10;
                    break;
                }
                case 1: {
                    if (this.choiceButtonWidgetList.size() > 2) {
                        currentY -= choiceButtonWidget.m_93694_() + spacing;
                        currentX = this.f_96543_ / 2 - choiceButtonWidget.m_5711_() / 2;
                        offsetY = 10;
                        break;
                    }
                    currentX = this.f_96543_ / 2 + spacing;
                    offsetX = -10;
                    break;
                }
                case 2: {
                    currentX = this.f_96543_ / 2 + maxWidthUpDown / 2;
                    offsetX = -10;
                    break;
                }
                case 3: {
                    currentY += choiceButtonWidget.m_93694_() + spacing;
                    currentX = this.f_96543_ / 2 - choiceButtonWidget.m_5711_() / 2;
                    offsetY = -10;
                }
            }
            choiceButtonWidget.m_252865_(currentX);
            choiceButtonWidget.m_253211_(currentY);
            this.m_142416_((GuiEventListener)choiceButtonWidget);
            AnimatedChoice animatedChoice = new AnimatedChoice(choiceButtonWidget, offsetX, offsetY);
            this.animatedChoices.add(animatedChoice);
        }
        if (!this.initiated) {
            this.t = 0.0;
            this.initiated = true;
        } else {
            this.t = 1.0;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return false;
        }
        if (this.storyHandler == null) {
            this.f_96541_.m_91152_(null);
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        List<KeyMapping> choiceKeys = List.of(ModKeys.SELECT_CHOICE_1, ModKeys.SELECT_CHOICE_2, ModKeys.SELECT_CHOICE_3, ModKeys.SELECT_CHOICE_4);
        for (int i = 0; i < this.choiceList.size(); ++i) {
            if (keyCode != choiceKeys.get(i).m_90861_().m_84873_()) continue;
            this.f_96541_.m_91152_(null);
            try {
                int finalI = i;
                NarrativeCraftMod.server.execute(() -> this.storyHandler.chooseChoiceAndNext(finalI));
                continue;
            }
            catch (Exception e) {
                this.storyHandler.stop();
                Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.t = Mth.m_14008_((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        for (AnimatedChoice ac : this.animatedChoices) {
            int newOpacity = (int)Mth.m_14139_((double)this.t, (double)5.0, (double)255.0);
            guiGraphics.m_280168_().m_85836_();
            if (this.choiceList.size() > 1) {
                guiGraphics.m_280168_().m_252880_((float)Mth.m_14139_((double)this.t, (double)ac.offsetX, (double)0.0), (float)Mth.m_14139_((double)this.t, (double)ac.offsetY, (double)0.0), 0.0f);
            }
            ac.widget.setOpacity(newOpacity);
            ac.widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.m_280168_().m_85849_();
            if (!(this.t >= 1.0)) continue;
            ac.widget.setCanPress(true);
        }
    }

    protected void m_267719_() {
        this.animatedChoices.clear();
        super.m_267719_();
    }

    public void m_7379_() {
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    private record AnimatedChoice(ChoiceButtonWidget widget, int offsetX, int offsetY) {
    }
}

