/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.animations;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.animations.EditScreenAnimationAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class AnimationsScreen
extends StoryElementScreen {
    private final Scene scene;

    public AnimationsScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.animation_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getAnimations().stream().map(animation -> {
            Button button = Button.m_253074_((Component)Component.m_237113_((String)animation.getName()), button1 -> {}).m_253136_();
            button.f_93623_ = false;
            return new StoryElementList.StoryEntryData(button, List.of(this.createSettingsButton((Animation)animation)), () -> this.f_96541_.m_91152_(new EditInfoScreen<Animation>((Screen)this, (Animation)animation, new EditScreenAnimationAdapter(this.scene))), () -> {
                this.f_96541_.m_91152_((Screen)new AnimationsScreen(this.scene));
                this.scene.removeAnimation((Animation)animation);
                NarrativeCraftFile.deleteAnimationFile(animation);
                this.f_96541_.m_91152_((Screen)new AnimationsScreen(this.scene));
            });
        }).toList();
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }

    private Button createSettingsButton(Animation animation) {
        return Button.m_253074_((Component)ImageFontConstants.SETTINGS, button1 -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((Screen)this, Translation.message("screen.story_manager.link_animation_character", new Object[0]).getString(), animation.getCharacter(), this.scene, characterStory -> {
                if (characterStory == null) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("character.must_link_character", new Object[0]));
                    return;
                }
                CharacterStory oldCharacter = animation.getCharacter();
                try {
                    animation.setCharacter((CharacterStory)characterStory);
                    NarrativeCraftFile.updateAnimationFile(animation);
                }
                catch (IOException e) {
                    Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
                    animation.setCharacter(oldCharacter);
                }
            });
            this.f_96541_.m_91152_((Screen)screen);
        }).m_253136_();
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.m_137581_().m_137644_(NarrativeCraftFile.getAnimationsFolder(this.scene));
    }
}

