/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.animations;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.animations.AnimationsScreen;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenAnimationAdapter
implements EditScreenAdapter<Animation> {
    private final Scene scene;

    public EditScreenAnimationAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Animation> screen, Animation entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Animation> screen, Animation entry, int x, int y) {
    }

    @Override
    public void buildFromScreen(Screen screen, Map<String, Object> extraFields, Minecraft minecraft, @Nullable Animation existing, String name, String description) {
        if (existing == null) {
            return;
        }
        Animation oldAnimation = new Animation(existing.getName(), this.scene);
        List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
        try {
            existing.setName(name);
            existing.setDescription(description);
            NarrativeCraftFile.updateAnimationFile(oldAnimation, existing);
            for (Chapter chapter : chapters) {
                for (Scene scene : chapter.getSortedSceneList()) {
                    NarrativeCraftFile.updateSubsceneFile(scene);
                    NarrativeCraftFile.updateCutsceneFile(scene);
                }
            }
            minecraft.m_91152_((Screen)new AnimationsScreen(this.scene));
        }
        catch (Exception e) {
            existing.setName(oldAnimation.getName());
            existing.setDescription(oldAnimation.getDescription());
            Util.sendCrashMessage((Player)minecraft.f_91074_, e);
            minecraft.m_91152_(null);
        }
    }
}

