/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.areaTrigger;

import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.areaTrigger.AreaTriggersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EditScreenAreaTriggerAdapter
implements EditScreenAdapter<AreaTrigger> {
    private final Screen lastScreen;
    private final Interaction interaction;
    private final InteractionController interactionController;

    public EditScreenAreaTriggerAdapter(Screen lastScreen, InteractionController interactionController) {
        this.lastScreen = lastScreen;
        this.interaction = interactionController.getInteraction();
        this.interactionController = interactionController;
    }

    @Override
    public void initExtraFields(EditInfoScreen<AreaTrigger> screen, AreaTrigger entry) {
        ScreenUtils.LabelBox stitch = new ScreenUtils.LabelBox((Component)Translation.message("global.stitch", new Object[0]), EditScreenAreaTriggerAdapter.minecraft.f_91062_, 110, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
        screen.extraFields.put("stitchBox", stitch.getEditBox());
        screen.extraFields.put("stitch", stitch);
        Checkbox isUniqueBox = new Checkbox(0, 0, 20, 20, (Component)Translation.message("screen.story_manager.area_trigger.is_unique", new Object[0]), entry != null && entry.isUnique());
        isUniqueBox.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.area_trigger.is_unique_explanation", new Object[0])));
        screen.extraFields.put("uniqueBox", isUniqueBox);
    }

    @Override
    public void renderExtraFields(EditInfoScreen<AreaTrigger> screen, AreaTrigger entry, int x, int y) {
        ScreenUtils.LabelBox stitch = (ScreenUtils.LabelBox)screen.extraFields.get("stitch");
        screen.m_142416_((AreaTrigger)stitch.getStringWidget());
        screen.m_142416_((AreaTrigger)stitch.getEditBox());
        stitch.setPosition(x, y);
        if (entry != null) {
            stitch.getEditBox().m_94144_(entry.getStitch());
        }
        Checkbox isUniqueBox = (Checkbox)screen.extraFields.get("uniqueBox");
        screen.m_142416_((AreaTrigger)isUniqueBox);
        isUniqueBox.m_264152_(x, y += stitch.getEditBox().m_93694_() + screen.GAP);
    }

    @Override
    public void buildFromScreen(Screen screen, Map<String, Object> extraFields, Minecraft minecraft, @Nullable AreaTrigger existing, String name, String description) {
        ScreenUtils.LabelBox stitch = (ScreenUtils.LabelBox)extraFields.get("stitch");
        Checkbox isUniqueBox = (Checkbox)extraFields.get("uniqueBox");
        if (existing == null) {
            if (this.interactionController.areaTriggerExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("interaction.area_trigger.already_exists", name, this.interaction.getName()));
                return;
            }
            AreaTrigger areaTrigger = new AreaTrigger(name, description, this.interaction.getScene(), stitch.getEditBox().m_94155_(), isUniqueBox.m_93840_());
            this.interactionController.getAreaTriggers().add(areaTrigger);
        } else {
            existing.setName(name);
            existing.setDescription(description);
            existing.setStitch(stitch.getEditBox().m_94155_());
            existing.setUnique(isUniqueBox.m_93840_());
        }
        minecraft.m_91152_((Screen)new AreaTriggersScreen(this.lastScreen, this.interactionController));
    }
}

