/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.character;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.character.CharacterModel;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.narrative.character.MainCharacterAttribute;
import fr.loudo.narrativecraft.screens.characters.CharacterAdvancedScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenCharacterAdapter
implements EditScreenAdapter<CharacterStory> {
    private final Scene scene;
    private MainCharacterAttribute attribute;

    public EditScreenCharacterAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<CharacterStory> screen, CharacterStory entry) {
        if (this.scene == null) {
            LocalDate localDate = LocalDate.now();
            ScreenUtils.LabelBox dayLabelBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Day"), screen.getFont(), 20, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            screen.extraFields.put("day", dayLabelBox);
            screen.extraFields.put("dayBox", dayLabelBox.getEditBox());
            dayLabelBox.getEditBox().m_94153_(string -> string.matches("^\\d*$"));
            dayLabelBox.getEditBox().m_94144_(String.valueOf(localDate.getDayOfMonth()));
            ScreenUtils.LabelBox monthLabelBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Month"), screen.getFont(), 20, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            monthLabelBox.getEditBox().m_94153_(string -> string.matches("^\\d*$"));
            monthLabelBox.getEditBox().m_94144_(String.valueOf(localDate.getMonthValue()));
            screen.extraFields.put("month", monthLabelBox);
            ScreenUtils.LabelBox yearLabelBox = new ScreenUtils.LabelBox((Component)Component.m_237113_((String)"Year"), screen.getFont(), 32, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
            yearLabelBox.getEditBox().m_94153_(string -> string.matches("^\\d*$"));
            yearLabelBox.getEditBox().m_94144_("2000");
            screen.extraFields.put("year", yearLabelBox);
        }
        Button modelButton = Button.m_253074_((Component)Component.m_237113_((String)CharacterModel.WIDE.name()), button -> {
            String currentModel = button.m_6035_().getString();
            if (currentModel.equalsIgnoreCase(CharacterModel.WIDE.name())) {
                button.m_93666_((Component)Component.m_237113_((String)CharacterModel.SLIM.name()));
            } else {
                button.m_93666_((Component)Component.m_237113_((String)CharacterModel.WIDE.name()));
            }
        }).m_252780_(70).m_253136_();
        screen.extraFields.put("modelBtn", modelButton);
        if (this.attribute == null && this.scene == null) {
            this.attribute = entry == null ? new MainCharacterAttribute() : new MainCharacterAttribute(entry.getMainCharacterAttribute());
        }
        if (entry != null) {
            if (this.scene == null) {
                String[] birthDateSplit = entry.getBirthDate().split("/");
                try {
                    ScreenUtils.LabelBox dayLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("day");
                    ScreenUtils.LabelBox monthLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("month");
                    ScreenUtils.LabelBox yearLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("year");
                    dayLabelBox.getEditBox().m_94144_(birthDateSplit[0]);
                    monthLabelBox.getEditBox().m_94144_(birthDateSplit[1]);
                    yearLabelBox.getEditBox().m_94144_(birthDateSplit[2]);
                }
                catch (Exception e) {
                    Util.sendCrashMessage((Player)Minecraft.m_91087_().f_91074_, e);
                    Minecraft.m_91087_().m_91152_(null);
                }
            }
            modelButton.m_93666_((Component)Component.m_237113_((String)entry.getModel().name()));
        }
    }

    @Override
    public void renderExtraFields(EditInfoScreen<CharacterStory> screen, CharacterStory entry, int x, int y) {
        if (this.scene == null) {
            ScreenUtils.LabelBox dayLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("day");
            dayLabelBox.setPosition(x, y);
            screen.m_142416_((CharacterStory)dayLabelBox.getEditBox());
            screen.m_142416_((CharacterStory)dayLabelBox.getStringWidget());
            ScreenUtils.LabelBox monthLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("month");
            monthLabelBox.setPosition(dayLabelBox.getEditBox().m_252754_() + dayLabelBox.getEditBox().m_5711_() + 10, y);
            screen.m_142416_((CharacterStory)monthLabelBox.getEditBox());
            screen.m_142416_((CharacterStory)monthLabelBox.getStringWidget());
            ScreenUtils.LabelBox yearLabelBox = (ScreenUtils.LabelBox)screen.extraFields.get("year");
            yearLabelBox.setPosition(monthLabelBox.getEditBox().m_252754_() + monthLabelBox.getEditBox().m_5711_() + 10, y);
            screen.m_142416_((CharacterStory)yearLabelBox.getEditBox());
            screen.m_142416_((CharacterStory)yearLabelBox.getStringWidget());
            y += yearLabelBox.getEditBox().m_93694_() + screen.GAP;
        }
        Button modelButton = (Button)screen.extraFields.get("modelBtn");
        MutableComponent label = Component.m_237113_((String)"Model");
        Font font = screen.getFont();
        int n = y + modelButton.m_93694_() / 2;
        Objects.requireNonNull(screen.getFont());
        StringWidget modelText = ScreenUtils.text((Component)label, font, x, n - 9 / 2);
        screen.m_142416_((CharacterStory)modelText);
        screen.m_142416_((CharacterStory)modelButton);
        modelButton.m_264152_(x + modelText.m_5711_() + 5, y);
        if (entry != null) {
            Button advancedBtn = Button.m_253074_((Component)Translation.message("global.advanced", new Object[0]), button -> {
                screen.setName(screen.getNameBox().getEditBox().m_94155_());
                screen.setDescription(screen.getDescriptionBox().getMultiLineEditBox().m_239249_());
                CharacterAdvancedScreen screen1 = new CharacterAdvancedScreen(screen, entry);
                minecraft.m_91152_((Screen)screen1);
            }).m_252780_(83).m_253136_();
            advancedBtn.m_264152_(modelButton.m_252754_() + modelButton.m_5711_() + 5, y);
            screen.m_142416_((CharacterStory)advancedBtn);
        }
    }

    @Override
    public void buildFromScreen(Screen screen, Map<String, Object> extraFields, Minecraft minecraft, @Nullable CharacterStory existing, String name, String description) {
        CharacterStory newCharacter;
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        CharacterStory currentMainCharacter = characterManager.getMainCharacter();
        CharacterModel model = CharacterModel.valueOf(((Button)extraFields.get("modelBtn")).m_6035_().getString());
        if (this.scene == null) {
            String day = ((ScreenUtils.LabelBox)extraFields.get("day")).getEditBox().m_94155_();
            String month = ((ScreenUtils.LabelBox)extraFields.get("month")).getEditBox().m_94155_();
            String year = ((ScreenUtils.LabelBox)extraFields.get("year")).getEditBox().m_94155_();
            newCharacter = new CharacterStory(name, description, day, month, year, model, CharacterType.MAIN);
        } else {
            newCharacter = new CharacterStory(name, description, "You", "are", "handsome <3", model, CharacterType.NPC);
        }
        if (existing == null) {
            if (characterManager.characterExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("character.already_exists", name));
                return;
            }
            try {
                if (this.scene == null) {
                    if (characterManager.getCharacterStories().isEmpty()) {
                        newCharacter.getMainCharacterAttribute().setMainCharacter(true);
                    }
                    NarrativeCraftFile.createCharacterFolder(newCharacter);
                    characterManager.addCharacter(newCharacter);
                } else {
                    NarrativeCraftFile.createCharacterFolder(newCharacter, this.scene);
                    this.scene.addNpc(newCharacter);
                }
                newCharacter.setMainCharacterAttribute(this.attribute);
                this.updateMainCharacter(currentMainCharacter, newCharacter);
                minecraft.m_91152_((Screen)new CharactersScreen(this.scene));
            }
            catch (Exception e) {
                Util.sendCrashMessage((Player)minecraft.f_91074_, e);
                minecraft.m_91152_(null);
            }
        } else {
            List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
            try {
                newCharacter.setShowNametag(existing.showNametag());
                if (this.scene == null) {
                    newCharacter.setMainCharacterAttribute(existing.getMainCharacterAttribute());
                    NarrativeCraftFile.updateCharacterData(existing, newCharacter);
                } else {
                    newCharacter.setMainCharacterAttribute(null);
                    NarrativeCraftFile.updateCharacterData(existing, newCharacter, this.scene);
                }
                existing.setName(newCharacter.getName());
                existing.setDescription(newCharacter.getDescription());
                existing.setMainCharacterAttribute(newCharacter.getMainCharacterAttribute());
                existing.setShowNametag(newCharacter.showNametag());
                if (this.scene == null) {
                    existing.setBirthDate(newCharacter.getBirthDate());
                }
                existing.setModel(newCharacter.getModel());
                for (Chapter chapter : chapters) {
                    for (Scene scene : chapter.getSortedSceneList()) {
                        for (Animation animation : scene.getAnimations()) {
                            NarrativeCraftFile.updateAnimationFile(animation);
                        }
                        NarrativeCraftFile.updateCameraAngles(scene);
                    }
                }
                this.updateMainCharacter(currentMainCharacter, newCharacter);
                minecraft.m_91152_((Screen)new CharactersScreen(this.scene));
            }
            catch (Exception e) {
                Util.sendCrashMessage((Player)minecraft.f_91074_, e);
                minecraft.m_91152_(null);
            }
        }
    }

    private void updateMainCharacter(CharacterStory currentMainCharacter, CharacterStory newCharacter) throws IOException {
        if (this.attribute == null) {
            return;
        }
        if (currentMainCharacter != null && this.attribute.isMainCharacter() && !currentMainCharacter.getName().equalsIgnoreCase(newCharacter.getName())) {
            currentMainCharacter.getMainCharacterAttribute().setMainCharacter(false);
            NarrativeCraftFile.updateCharacterData(currentMainCharacter, currentMainCharacter);
        }
    }
}

