/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.interaction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.interaction.EditScreenInteractionAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class InteractionsScreen
extends StoryElementScreen {
    private final Scene scene;

    public InteractionsScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.interaction_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Interaction> screen = new EditInfoScreen<Interaction>((Screen)this, null, new EditScreenInteractionAdapter(this.scene));
            this.f_96541_.m_91152_(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getInteractions().stream().map(interaction -> {
            Button button = Button.m_253074_((Component)Component.m_237113_((String)interaction.getName()), button1 -> {
                NarrativeCraftMod.server.execute(() -> new InteractionController(Environment.DEVELOPMENT, (Player)this.f_96541_.f_91074_, (Interaction)interaction).startSession());
                this.f_96541_.m_91152_(null);
            }).m_253136_();
            return new StoryElementList.StoryEntryData(button, () -> this.f_96541_.m_91152_(new EditInfoScreen<Interaction>((Screen)this, (Interaction)interaction, new EditScreenInteractionAdapter(this.scene))), () -> {
                try {
                    this.scene.removeInteraction((Interaction)interaction);
                    NarrativeCraftFile.updateInteractionsFile(this.scene);
                }
                catch (Exception e) {
                    this.scene.addInteraction((Interaction)interaction);
                    Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
                }
                this.f_96541_.m_91152_((Screen)new InteractionsScreen(this.scene));
            });
        }).toList();
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.m_137581_().m_137644_(NarrativeCraftFile.getSceneFolder(this.scene));
    }
}

