/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.animations.AnimationsScreen;
import fr.loudo.narrativecraft.screens.storyManager.cameraAngle.CameraAngleScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.screens.storyManager.cutscene.CutscenesScreen;
import fr.loudo.narrativecraft.screens.storyManager.interaction.InteractionsScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesScreen;
import fr.loudo.narrativecraft.screens.storyManager.subscene.SubscenesScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ScenesMenuScreen
extends StoryElementScreen {
    private final Scene scene;

    public ScenesMenuScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.scene_menu", scene.getName()));
        this.scene = scene;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new ScenesScreen(this.scene.getChapter()));
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        GridLayout gridlayout = ((GridLayout)this.layout.m_269281_((LayoutElement)new GridLayout())).m_267612_(8);
        GridLayout.RowHelper rowHelper = gridlayout.m_264606_(2);
        int width = 200;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)this.f_96541_.f_91074_);
        if (playerSession.isSessionSet() && playerSession.getScene().equals(this.scene)) {
            width = 100;
            rowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> {
                ScenesScreen screen = new ScenesScreen(this.scene.getChapter());
                this.f_96541_.m_91152_((Screen)screen);
            }).m_252780_(width).m_253136_());
            rowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, p_345997_ -> this.f_96541_.m_91152_(null)).m_252780_(width).m_253136_());
        } else {
            this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> this.m_7379_()).m_252780_(width).m_253136_());
        }
    }

    @Override
    protected void addContents() {
        StoryElementList.StoryEntryData animation = new StoryElementList.StoryEntryData(Button.m_253074_((Component)Translation.message("global.animation", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new AnimationsScreen(this.scene))).m_253136_());
        StoryElementList.StoryEntryData cameraAngle = new StoryElementList.StoryEntryData(Button.m_253074_((Component)Translation.message("global.camera_angle", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new CameraAngleScreen(this.scene))).m_253136_());
        StoryElementList.StoryEntryData cutscene = new StoryElementList.StoryEntryData(Button.m_253074_((Component)Translation.message("global.cutscene", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new CutscenesScreen(this.scene))).m_253136_());
        Button interactionBtn = Button.m_253074_((Component)Translation.message("global.interaction", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new InteractionsScreen(this.scene))).m_253136_();
        StoryElementList.StoryEntryData interaction = new StoryElementList.StoryEntryData(interactionBtn);
        StoryElementList.StoryEntryData npc = new StoryElementList.StoryEntryData(Button.m_253074_((Component)Translation.message("global.npc", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new CharactersScreen(this.scene))).m_253136_());
        StoryElementList.StoryEntryData subscene = new StoryElementList.StoryEntryData(Button.m_253074_((Component)Translation.message("global.subscene", new Object[0]), button -> this.f_96541_.m_91152_((Screen)new SubscenesScreen(this.scene))).m_253136_());
        List<StoryElementList.StoryEntryData> entries = List.of(animation, cameraAngle, cutscene, interaction, npc, subscene);
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }

    @Override
    protected void openFolder() {
        Util.m_137581_().m_137644_(NarrativeCraftFile.getSceneFolder(this.scene));
    }
}

