/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.EditScreenSceneAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ScenesScreen
extends StoryElementScreen {
    private final Chapter chapter;

    public ScenesScreen(Chapter chapter) {
        super((Component)Translation.message("screen.story_manager.scene_list", chapter.getIndex()));
        this.chapter = chapter;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Scene> screen = new EditInfoScreen<Scene>((Screen)this, null, new EditScreenSceneAdapter(this.chapter));
            this.f_96541_.m_91152_(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    public void m_7379_() {
        ChaptersScreen screen = new ChaptersScreen();
        this.f_96541_.m_91152_((Screen)screen);
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.chapter.getSortedSceneList().stream().map(scene -> {
            Button button = Button.m_253074_((Component)Component.m_237113_((String)scene.getName()), b -> this.f_96541_.m_91152_((Screen)new ScenesMenuScreen((Scene)scene))).m_253136_();
            return new StoryElementList.StoryEntryData(button, () -> this.f_96541_.m_91152_(new EditInfoScreen<Scene>((Screen)this, (Scene)scene, new EditScreenSceneAdapter(this.chapter))), () -> {
                try {
                    this.chapter.removeScene((Scene)scene);
                    NarrativeCraftFile.deleteSceneDirectory(scene);
                    if (scene.getRank() == 1 && this.chapter.getSortedSceneList().size() > 1) {
                        NarrativeCraftFile.updateMasterSceneKnot(this.chapter.getSortedSceneList().get(0));
                    }
                    this.f_96541_.m_91152_((Screen)new ScenesScreen(this.chapter));
                }
                catch (Exception e) {
                    this.chapter.addScene((Scene)scene);
                    this.chapter.setSceneRank((Scene)scene, scene.getRank());
                    Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
                    this.f_96541_.m_91152_(null);
                }
            });
        }).toList();
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.m_137581_().m_137644_(NarrativeCraftFile.getScenesFolder(this.chapter));
    }
}

