/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ErrorLine {
    private final boolean isWarn;
    private final int line;
    private final Scene scene;
    private final Chapter chapter;
    private String fileName;
    private final String message;
    private final String lineText;

    public ErrorLine(int line, Chapter chapter, Scene scene, String message, String lineText, boolean isWarn) {
        this.line = line;
        this.chapter = chapter;
        this.scene = scene;
        if (scene != null) {
            this.fileName = scene.knotName() + ".ink";
        } else if (chapter != null) {
            this.fileName = chapter.knotName() + ".ink";
        }
        this.message = message;
        this.lineText = lineText;
        this.isWarn = isWarn;
    }

    public Component toMessage() {
        Chapter chapterToDisplay;
        if (this.scene == null && this.chapter == null) {
            return Component.m_237119_().m_7220_((Component)Component.m_237113_((String)this.lineText).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131136_(Boolean.valueOf(false)))).m_130946_("\n").m_7220_((Component)Component.m_237113_((String)("'" + this.message + "'")).m_130940_(ChatFormatting.RED).m_130938_(style -> style.m_131136_(Boolean.valueOf(false)))).m_130946_("\n");
        }
        MutableComponent result = Component.m_237119_().m_130946_("\n");
        Chapter chapter = chapterToDisplay = this.scene != null ? this.scene.getChapter() : this.chapter;
        if (chapterToDisplay != null) {
            result = result.m_6881_().m_7220_((Component)Component.m_237113_((String)"Chapter: ").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)).m_7220_((Component)Component.m_237113_((String)String.valueOf(chapterToDisplay.getIndex())).m_130940_(ChatFormatting.RED).m_130938_(style -> style.m_131136_(Boolean.valueOf(false)))).m_130946_("\n");
        }
        if (this.scene != null) {
            result = result.m_6881_().m_7220_((Component)Component.m_237113_((String)"Scene: ").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)).m_7220_((Component)Component.m_237113_((String)(this.scene.getName() + " ")).m_130940_(ChatFormatting.RED).m_130938_(style -> style.m_131136_(Boolean.valueOf(false))));
        }
        if (this.fileName != null) {
            result = result.m_6881_().m_7220_((Component)Component.m_237113_((String)("(" + this.fileName + ")")).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131136_(Boolean.valueOf(false)))).m_130946_("\n");
        }
        result = result.m_6881_().m_7220_((Component)Translation.message("global.line", new Object[0]).m_130940_(ChatFormatting.GOLD)).m_130946_(" " + this.line + ": ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)this.lineText).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131136_(Boolean.valueOf(false)))).m_130946_("\n").m_7220_((Component)Component.m_237113_((String)("'" + this.message + "'")).m_130940_(this.isWarn ? ChatFormatting.YELLOW : ChatFormatting.RED).m_130938_(style -> style.m_131136_(Boolean.valueOf(false)))).m_130946_("\n");
        return result;
    }

    public int getLine() {
        return this.line;
    }

    public Scene getScene() {
        return this.scene;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLineText() {
        return this.lineText;
    }

    public boolean isWarn() {
        return this.isWarn;
    }
}

