/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.geometric.DialogTail;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Position2D;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DialogRenderer3D
extends DialogRenderer {
    private final DialogTail dialogTail;
    private final String characterName;
    private DialogEntityBobbing dialogEntityBobbing;
    private Position2D dialogOffset;
    private CharacterRuntime characterRuntime;
    private class_243 dialogPosition;

    public DialogRenderer3D(String text, String characterName, CharacterRuntime characterRuntime, Position2D dialogOffset, float width, float paddingX, float paddingY, float scale, float letterSpacing, float gap, int backgroundColor, int textColor) {
        super(text, width, paddingX, paddingY, scale, letterSpacing, gap, backgroundColor, textColor);
        this.characterName = characterName;
        this.characterRuntime = characterRuntime;
        this.dialogOffset = dialogOffset;
        this.dialogTail = new DialogTail(this, 5.0f, 10.0f, 0.0f);
    }

    public DialogRenderer3D(String text, String characterName, DialogData dialogData, CharacterRuntime characterRuntime) {
        super(text, dialogData);
        this.characterName = characterName;
        this.characterRuntime = characterRuntime;
        this.dialogOffset = dialogData.getOffset();
        this.dialogTail = new DialogTail(this, 5.0f, 10.0f, 0.0f);
    }

    @Override
    public void tick() {
        if (this.dialogPosition == null) {
            return;
        }
        this.dialogEntityBobbing.tick();
        super.tick();
    }

    private void updateDialogPosition() {
        class_1297 entity;
        class_1309 serverEntity = this.characterRuntime.getEntity();
        if (serverEntity != null && (entity = this.minecraft.field_1687.method_8469(this.characterRuntime.getEntity().method_5628())) != null) {
            this.dialogPosition = entity.method_19538().method_1031(0.0, (double)entity.method_5751(), 0.0);
        }
    }

    @Override
    public void render(class_4587 poseStack, float partialTick) {
        this.updateDialogPosition();
        if (this.dialogPosition == null) {
            return;
        }
        class_243 position = this.dialogPosition;
        position = this.translateToRelativeApplyOffset(position);
        float originalScale = this.scale;
        if (this.currentTick < this.totalTick) {
            double t = this.t(partialTick);
            t = Easing.SMOOTH.interpolate(t);
            if (this.dialogStarting || this.dialogStopping) {
                double opacity;
                if (this.dialogStarting) {
                    originalScale = (float)class_3532.method_16436((double)t, (double)0.0, (double)this.scale);
                    opacity = class_3532.method_16436((double)t, (double)0.0, (double)1.0);
                    position = this.getDialogInterpolatedAppearPosition(t);
                } else {
                    originalScale = (float)class_3532.method_16436((double)t, (double)this.scale, (double)0.0);
                    opacity = class_3532.method_16436((double)t, (double)1.0, (double)0.0);
                    position = this.getDialogInterpolatedDisappearPosition(t);
                }
                this.backgroundColor = class_9848.method_61330((int)((int)(opacity * 255.0)), (int)this.backgroundColor);
            } else {
                originalScale = (float)class_3532.method_16436((double)t, (double)this.oldScale, (double)this.scale);
            }
        }
        if (this.currentTick == this.totalTick) {
            if (this.dialogStopping && !this.dialogStarting) {
                this.dialogStopping = false;
            }
            if (this.dialogStarting && !this.dialogStopping) {
                this.dialogStarting = false;
            }
        }
        poseStack.method_22904(position.field_1352, position.field_1351, position.field_1350);
        poseStack.method_22907((Quaternionfc)this.minecraft.method_1561().method_24197());
        poseStack.method_22905(originalScale * 0.025f, -originalScale * 0.025f, originalScale * 0.025f);
        this.renderDialogBackground(poseStack, partialTick);
        Side side = this.dialogOffsetSide();
        poseStack.method_22903();
        if (side == Side.DOWN) {
            poseStack.method_46416(0.0f, this.dialogOffset.x == 0.0f ? this.height : this.height / 2.0f + this.paddingY / 2.0f, 0.0f);
        }
        this.dialogTail.render(poseStack, partialTick, this.minecraft.method_22940().method_23000(), this.minecraft.field_1773.method_19418());
        poseStack.method_22909();
        if (this.dialogOffset.y == 0.0f) {
            switch (side.ordinal()) {
                case 2: 
                case 3: {
                    poseStack.method_46416(0.0f, 0.0f, 0.0f);
                }
            }
        }
        poseStack.method_22903();
        if (side == Side.RIGHT) {
            if (this.dialogOffset.y == 0.0f) {
                poseStack.method_46416(this.totalWidth, this.totalHeight / 2.0f, 0.0f);
            } else if (this.dialogOffset.y > 0.0f) {
                poseStack.method_46416(this.totalWidth, 0.0f, 0.0f);
            } else if (this.dialogOffset.y < 0.0f) {
                poseStack.method_46416(this.totalWidth, this.totalHeight, 0.0f);
            }
        } else if (side == Side.LEFT) {
            if (this.dialogOffset.y == 0.0f) {
                poseStack.method_46416(-this.totalWidth, this.totalHeight / 2.0f, 0.0f);
            } else if (this.dialogOffset.y > 0.0f) {
                poseStack.method_46416(-this.totalWidth, 0.0f, 0.0f);
            } else if (this.dialogOffset.y < 0.0f) {
                poseStack.method_46416(-this.totalWidth, this.totalHeight, 0.0f);
            }
        } else if (side == Side.DOWN) {
            poseStack.method_46416(0.0f, this.totalHeight, 0.0f);
        }
        if (!this.dialogStopping) {
            this.dialogEntityBobbing.partialTick(partialTick);
            this.dialogScrollText.render(poseStack, this.minecraft.method_22940().method_23000(), partialTick);
            if (this.dialogScrollText.isFinished()) {
                if (!this.dialogAutoSkipping) {
                    this.dialogAutoSkipping = true;
                    this.currentTick = 0;
                }
                this.dialogArrowSkip.start();
            }
            if (!this.noSkip) {
                this.dialogArrowSkip.render(poseStack, this.minecraft.method_22940().method_23000(), partialTick);
            }
        }
        poseStack.method_22909();
        this.minecraft.method_22940().method_23000().method_22994(NarrativeCraftMod.dialogBackgroundRenderType);
    }

    public void updateBobbing(float value1, float value2) {
        this.dialogEntityBobbing.setNoiseShakeSpeed(value1);
        this.dialogEntityBobbing.setNoiseShakeStrength(value2);
    }

    private class_243 getDialogInterpolatedAppearPosition(double t) {
        class_243 dialogPos = this.translateToRelative(this.dialogPosition);
        class_243 dialogPositionOffsetApplied = this.translateToRelativeApplyOffset(this.dialogPosition);
        double x = class_3532.method_16436((double)t, (double)dialogPos.field_1352, (double)dialogPositionOffsetApplied.field_1352);
        double y = class_3532.method_16436((double)t, (double)dialogPos.field_1351, (double)dialogPositionOffsetApplied.field_1351);
        double z = class_3532.method_16436((double)t, (double)dialogPos.field_1350, (double)dialogPositionOffsetApplied.field_1350);
        return new class_243(x, y, z);
    }

    private class_243 getDialogInterpolatedDisappearPosition(double t) {
        class_243 dialogPos = this.translateToRelative(this.dialogPosition);
        class_243 dialogPositionOffsetApplied = this.translateToRelativeApplyOffset(this.dialogPosition);
        double x = class_3532.method_16436((double)t, (double)dialogPositionOffsetApplied.field_1352, (double)dialogPos.field_1352);
        double y = class_3532.method_16436((double)t, (double)dialogPositionOffsetApplied.field_1351, (double)dialogPos.field_1351);
        double z = class_3532.method_16436((double)t, (double)dialogPositionOffsetApplied.field_1350, (double)dialogPos.field_1350);
        return new class_243(x, y, z);
    }

    private void renderDialogBackground(class_4587 poseStack, float partialTick) {
        class_4597.class_4598 bufferSource = this.minecraft.method_22940().method_23000();
        class_4588 vertexConsumer = bufferSource.getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        Side side = this.dialogOffsetSide();
        double diffY = this.translateToRelativeApplyOffset((class_243)this.dialogPosition).field_1351 - this.translateToRelative((class_243)this.dialogPosition).field_1351;
        float originalWidth = this.totalWidth;
        float originalHeight = this.totalHeight;
        if (this.isAnimating() && !this.dialogStarting && !this.dialogStopping) {
            originalWidth = this.getInterpolatedWidth(partialTick);
            originalHeight = this.getInterpolatedHeight(partialTick);
        } else {
            this.oldTotalWidth = this.totalWidth;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            this.oldTotalHeight = this.totalHeight;
            this.oldScale = this.scale;
        }
        switch (side.ordinal()) {
            case 0: {
                vertexConsumer.method_22918(matrix4f, -originalWidth, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, originalWidth, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, originalWidth, -originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, -originalWidth, -originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                break;
            }
            case 3: {
                if (diffY < 0.0) {
                    vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, 0.0f, originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, originalWidth * 2.0f, originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, originalWidth * 2.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    break;
                }
                if (diffY > 0.0) {
                    vertexConsumer.method_22918(matrix4f, 0.0f, -originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, originalWidth * 2.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, originalWidth * 2.0f, -originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    break;
                }
                vertexConsumer.method_22918(matrix4f, 0.0f, -originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, 0.0f, originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, originalWidth * 2.0f, originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, originalWidth * 2.0f, -originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                break;
            }
            case 2: {
                if (diffY < 0.0) {
                    vertexConsumer.method_22918(matrix4f, -originalWidth * 2.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, -originalWidth * 2.0f, originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, 0.0f, originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    break;
                }
                if (diffY > 0.0) {
                    vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, 0.0f, -originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, -originalWidth * 2.0f, -originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    vertexConsumer.method_22918(matrix4f, -originalWidth * 2.0f, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                    break;
                }
                vertexConsumer.method_22918(matrix4f, 0.0f, originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, 0.0f, -originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, -originalWidth * 2.0f, -originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, -originalWidth * 2.0f, originalHeight / 2.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                break;
            }
            case 1: {
                vertexConsumer.method_22918(matrix4f, -originalWidth, originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, originalWidth, originalHeight, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, originalWidth, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
                vertexConsumer.method_22918(matrix4f, -originalWidth, 0.0f, 0.0f).method_39415(this.backgroundColor).method_60803(0xF000F0);
            }
        }
    }

    private Side dialogOffsetSide() {
        class_243 dialogPos = this.translateToRelative(this.dialogPosition);
        class_243 dialogPosOffset = this.translateToRelativeApplyOffset(this.dialogPosition);
        double offsetX = 0.0;
        double offsetY = dialogPosOffset.field_1351 - dialogPos.field_1351;
        class_2350 direction = this.minecraft.field_1724.method_5735();
        if (direction == class_2350.field_11034) {
            offsetX = dialogPosOffset.field_1350 - dialogPos.field_1350;
        } else if (direction == class_2350.field_11039) {
            offsetX = dialogPos.field_1350 - dialogPosOffset.field_1350;
        } else if (direction == class_2350.field_11043) {
            offsetX = dialogPosOffset.field_1352 - dialogPos.field_1352;
        } else if (direction == class_2350.field_11035) {
            offsetX = dialogPos.field_1352 - dialogPosOffset.field_1352;
        }
        if (offsetY >= 0.0 && offsetX >= 0.0 && offsetX <= 0.0) {
            return Side.UP;
        }
        if (offsetY <= 0.0 && offsetX >= 0.0 && offsetX <= 0.0) {
            return Side.DOWN;
        }
        if (offsetX <= 0.0) {
            return Side.LEFT;
        }
        if (offsetX >= 0.0) {
            return Side.RIGHT;
        }
        return Side.UP;
    }

    public class_243 translateToRelative(class_243 worldPos) {
        class_243 camPos = this.minecraft.field_1773.method_19418().method_19326();
        return new class_243(worldPos.field_1352 - camPos.field_1352, worldPos.field_1351 - camPos.field_1351, worldPos.field_1350 - camPos.field_1350);
    }

    public class_243 translateToRelativeApplyOffset(class_243 position) {
        position = this.translateToRelative(position);
        double offsetX = 0.0;
        double offsetZ = 0.0;
        switch (this.minecraft.field_1724.method_5735()) {
            case field_11034: {
                offsetZ = this.dialogOffset.x;
                break;
            }
            case field_11039: {
                offsetZ = -this.dialogOffset.x;
                break;
            }
            case field_11035: {
                offsetX = -this.dialogOffset.x;
                break;
            }
            case field_11043: {
                offsetX = this.dialogOffset.x;
            }
        }
        return new class_243(position.field_1352 + offsetX, position.field_1351 + (double)this.dialogOffset.y, position.field_1350 + offsetZ);
    }

    public CharacterRuntime getCharacterRuntime() {
        return this.characterRuntime;
    }

    public void setCharacterRuntime(CharacterRuntime characterRuntime) {
        this.characterRuntime = characterRuntime;
    }

    public Position2D getDialogOffset() {
        return this.dialogOffset;
    }

    public void setDialogOffset(Position2D dialogOffset) {
        this.dialogOffset = dialogOffset;
    }

    public class_243 getDialogPosition() {
        return this.dialogPosition;
    }

    public class_243 getDialogPositionWithOffset() {
        return this.dialogPosition.method_1031((double)this.dialogOffset.x, this.dialogPosition.field_1351, this.dialogPosition.field_1350);
    }

    public String getCharacterName() {
        return this.characterName;
    }

    public DialogEntityBobbing getDialogEntityBobbing() {
        return this.dialogEntityBobbing;
    }

    public void setDialogEntityBobbing(DialogEntityBobbing dialogEntityBobbing) {
        this.dialogEntityBobbing = dialogEntityBobbing;
    }

    public static enum Side {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

